/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountElement;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountType;
import com.itextpdf.html2pdf.attach.impl.layout.PageTargetCountElement;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.css.resolve.func.counter.PageCountElementNode;
import com.itextpdf.html2pdf.css.resolve.func.counter.PageTargetCountElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class PageCountWorker
extends SpanTagWorker {
    private IPropertyContainer pageCountElement;

    public PageCountWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
        if (element instanceof PageCountElementNode) {
            CounterDigitsGlyphStyle digitsStyle = ((PageCountElementNode)element).getDigitsGlyphStyle();
            if (element instanceof PageTargetCountElementNode) {
                this.pageCountElement = new PageTargetCountElement(((PageTargetCountElementNode)element).getTarget(), digitsStyle);
            } else {
                boolean totalPageCount = ((PageCountElementNode)element).isTotalPageCount();
                this.pageCountElement = new PageCountElement(digitsStyle);
                this.pageCountElement.setProperty(0x100002, (Object)(totalPageCount ? PageCountType.TOTAL_PAGE_COUNT : PageCountType.CURRENT_PAGE_NUMBER));
            }
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processTagChild(this, context);
        super.processEnd(element, context);
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.pageCountElement;
    }
}

