/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.ImgTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.MulticolContainer;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class PTagWorker
implements ITagWorker,
IDisplayAware {
    private Paragraph lastParagraph = new Paragraph();
    private Div elementsContainer;
    protected MulticolContainer multicolContainer;
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public PTagWorker(IElementNode element, ProcessorContext context) {
        if (element.getStyles().get("column-count") != null || element.getStyles().get("column-width") != null) {
            this.multicolContainer = new MulticolContainer();
            this.multicolContainer.add(this.lastParagraph);
        }
        this.inlineHelper = new WaitingInlineElementsHelper(element.getStyles().get("white-space"), element.getStyles().get("text-transform"));
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves(this.lastParagraph);
        if (this.elementsContainer != null) {
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.elementsContainer, element);
        } else {
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.lastParagraph, element);
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (childTagWorker instanceof ImgTagWorker && "block".equals(((ImgTagWorker)childTagWorker).getDisplay())) {
            IPropertyContainer propertyContainer = childTagWorker.getElementResult();
            this.processBlockElement((Image)propertyContainer);
            return true;
        }
        if (element instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)element);
            return true;
        }
        if (childTagWorker instanceof IDisplayAware && ("inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) || "inline".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay())) && element instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)element);
            return true;
        }
        if (this.isBlockWithDisplay(childTagWorker, element, "inline-block", false)) {
            this.inlineHelper.add((IBlockElement)element);
            return true;
        }
        if (this.isBlockWithDisplay(childTagWorker, element, "block", false)) {
            IPropertyContainer propertyContainer = childTagWorker.getElementResult();
            this.processBlockElement((IBlockElement)propertyContainer);
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (this.isBlockWithDisplay(childTagWorker, propertyContainer, "inline-block", true)) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                if (this.isBlockWithDisplay(childTagWorker, propertyContainer, "block", true)) {
                    this.processBlockElement((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = false;
            }
            return allChildrenProcessed;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        if (this.multicolContainer == null) {
            return null == this.elementsContainer ? this.lastParagraph : this.elementsContainer;
        }
        return this.multicolContainer;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private void processBlockElement(IElement propertyContainer) {
        if (this.elementsContainer == null) {
            this.elementsContainer = new Div();
            this.elementsContainer.add(this.lastParagraph);
            if (this.multicolContainer != null) {
                this.multicolContainer.getChildren().clear();
                this.multicolContainer.add(this.elementsContainer);
            }
        }
        this.inlineHelper.flushHangingLeaves(this.lastParagraph);
        if (propertyContainer instanceof Image) {
            this.elementsContainer.add((Image)propertyContainer);
        } else {
            this.elementsContainer.add((IBlockElement)propertyContainer);
        }
        this.lastParagraph = new Paragraph();
        this.elementsContainer.add(this.lastParagraph);
    }

    private boolean isBlockWithDisplay(ITagWorker childTagWorker, IPropertyContainer element, String displayMode, boolean isChild) {
        if (isChild) {
            return element instanceof IBlockElement && displayMode.equals(((SpanTagWorker)childTagWorker).getElementDisplay(element));
        }
        return element instanceof IBlockElement && childTagWorker instanceof IDisplayAware && displayMode.equals(((IDisplayAware)((Object)childTagWorker)).getDisplay());
    }
}

