/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.util;

import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;

public final class BorderStyleUtil {
    public static void applyBorderProperty(IPropertyContainer container, PdfFormAnnotation annotation) {
        Border border = (Border)container.getProperty(11);
        if (border != null) {
            annotation.setBorderStyle(BorderStyleUtil.transformBorderTypeToBorderStyleDictionary(border.getType()));
            annotation.setBorderColor(border.getColor());
            annotation.setBorderWidth(border.getWidth());
        }
    }

    private static PdfDictionary transformBorderTypeToBorderStyleDictionary(int borderType) {
        PdfName style;
        PdfDictionary bs = new PdfDictionary();
        switch (borderType) {
            case 1001: {
                style = PdfAnnotation.STYLE_UNDERLINE;
                break;
            }
            case 1002: {
                style = PdfAnnotation.STYLE_BEVELED;
                break;
            }
            case 1003: {
                style = PdfAnnotation.STYLE_INSET;
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                style = PdfAnnotation.STYLE_DASHED;
                break;
            }
            default: {
                style = PdfAnnotation.STYLE_SOLID;
            }
        }
        bs.put(PdfName.S, style);
        return bs;
    }

    private BorderStyleUtil() {
    }
}

