/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;

public class SelectFieldItem {
    private final String exportValue;
    private final String displayValue;
    private final IBlockElement optionElement;

    public SelectFieldItem(String exportValue, String displayValue) {
        this(exportValue, displayValue, ((Paragraph)new Paragraph(displayValue).setMargin(0.0f)).setMultipliedLeading(1.0f));
    }

    public SelectFieldItem(String value) {
        this(value, null, ((Paragraph)new Paragraph(value).setMargin(0.0f)).setMultipliedLeading(1.0f));
    }

    public SelectFieldItem(String value, IBlockElement optionElement) {
        this(value, null, optionElement);
    }

    public SelectFieldItem(String exportValue, String displayValue, IBlockElement optionElement) {
        if (exportValue == null) {
            throw new PdfException(MessageFormatUtil.format("Value <{0}> shall not be null", "exportValue"));
        }
        this.exportValue = exportValue;
        this.displayValue = displayValue;
        if (optionElement == null) {
            throw new PdfException("Option element shall not be null.");
        }
        this.optionElement = optionElement;
        this.setLabel();
    }

    public String getExportValue() {
        return this.exportValue;
    }

    public String getDisplayValue() {
        if (this.displayValue != null) {
            return this.displayValue;
        }
        return this.exportValue;
    }

    public IBlockElement getElement() {
        return this.optionElement;
    }

    public boolean hasExportAndDisplayValues() {
        return this.exportValue != null && this.displayValue != null;
    }

    private void setLabel() {
        this.optionElement.setProperty(0x20000A, this.getDisplayValue());
    }
}

