/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.forms.FormDefaultAccessibilityProperties;
import com.itextpdf.forms.form.element.FormField;
import com.itextpdf.forms.form.element.IPlaceholderable;
import com.itextpdf.forms.form.renderer.InputFieldRenderer;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;

public class InputField
extends FormField<InputField>
implements IPlaceholderable {
    private static final float X_OFFSET = 2.0f;
    private Paragraph placeholder;
    private int rotation = 0;

    public InputField(String id) {
        super(id);
        this.setProperties();
    }

    public InputField useAsPassword(boolean isPassword) {
        this.setProperty(0x200004, isPassword);
        return this;
    }

    @Override
    public Paragraph getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public void setPlaceholder(Paragraph placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 0x200004: {
                return (T1)Boolean.valueOf(false);
            }
            case 0x200002: {
                return (T1)Integer.valueOf(20);
            }
            case 0x200011: {
                return (T1)Boolean.valueOf(false);
            }
            case 0x200012: {
                return (T1)Integer.valueOf(0);
            }
        }
        return super.getDefaultProperty(property);
    }

    public int getRotation() {
        return this.rotation;
    }

    public InputField setRotation(int rotation) {
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Invalid rotation. Rotation must be a multiple of 90 degrees.");
        }
        this.rotation = rotation;
        return this;
    }

    public InputField setComb(boolean isComb) {
        this.setProperty(0x200011, isComb);
        return this;
    }

    public InputField setMaxLen(int maxLen) {
        this.setProperty(0x200012, maxLen);
        return this;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new FormDefaultAccessibilityProperties("tv");
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new InputFieldRenderer(this);
    }

    private void setProperties() {
        this.setProperty(48, UnitValue.createPointValue(2.0f));
        this.setProperty(49, UnitValue.createPointValue(2.0f));
        this.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
    }
}

