/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode1D;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import java.awt.Color;
import java.awt.Image;

public class BarcodeEANSUPP
extends Barcode1D {
    protected Barcode1D ean;
    protected Barcode1D supp;

    public BarcodeEANSUPP(Barcode1D ean, Barcode1D supp) {
        super(ean.document);
        this.n = 8.0f;
        this.ean = ean;
        this.supp = supp;
    }

    @Override
    public Rectangle getBarcodeSize() {
        Rectangle rect = this.ean.getBarcodeSize();
        rect.setWidth(rect.getWidth() + this.supp.getBarcodeSize().getWidth() + this.n);
        return rect;
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.colors.Color barColor, com.itextpdf.kernel.colors.Color textColor) {
        if (this.supp.getFont() == null) {
            this.supp.setBarHeight(this.ean.getBarHeight());
        } else {
            float sizeCoefficient = FontProgram.convertTextSpaceToGlyphSpace(this.supp.getSize());
            this.supp.setBarHeight(this.ean.getBarHeight() + this.supp.getBaseline() - (float)this.supp.getFont().getFontProgram().getFontMetrics().getCapHeight() * sizeCoefficient);
        }
        Rectangle eanR = this.ean.getBarcodeSize();
        canvas.saveState();
        this.ean.placeBarcode(canvas, barColor, textColor);
        canvas.restoreState();
        canvas.saveState();
        canvas.concatMatrix(1.0, 0.0, 0.0, 1.0, eanR.getWidth() + this.n, eanR.getHeight() - this.ean.getBarHeight());
        this.supp.placeBarcode(canvas, barColor, textColor);
        canvas.restoreState();
        return this.getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color foreground, Color background) {
        throw new UnsupportedOperationException("The two barcodes must be composed externally.");
    }
}

