/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode1D;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeCodabar
extends Barcode1D {
    private static final String CHARS = "0123456789-$:/.+ABCD";
    private static final int START_STOP_IDX = 16;
    private static final byte[][] BARS = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}};

    public BarcodeCodabar(PdfDocument document) {
        this(document, document.getDefaultFont());
    }

    public BarcodeCodabar(PdfDocument document, PdfFont font) {
        super(document);
        this.x = 0.8f;
        this.n = 2.0f;
        this.font = font;
        this.baseline = this.size = 8.0f;
        this.barHeight = this.size * 3.0f;
        this.textAlignment = 3;
        this.generateChecksum = false;
        this.checksumText = false;
        this.startStopText = false;
    }

    public static byte[] getBarsCodabar(String text) {
        int len = (text = text.toUpperCase()).length();
        if (len < 2) {
            throw new IllegalArgumentException("Codabar must have at least start and stop character.");
        }
        if (CHARS.indexOf(text.charAt(0)) < 16 || CHARS.indexOf(text.charAt(len - 1)) < 16) {
            throw new IllegalArgumentException("Codabar must have one of 'ABCD' as start/stop character.");
        }
        byte[] bars = new byte[text.length() * 8 - 1];
        for (int k = 0; k < len; ++k) {
            int idx = CHARS.indexOf(text.charAt(k));
            if (idx >= 16 && k > 0 && k < len - 1) {
                throw new IllegalArgumentException("In Codabar, start/stop characters are only allowed at the extremes.");
            }
            if (idx < 0) {
                throw new IllegalArgumentException("Illegal character in Codabar Barcode.");
            }
            System.arraycopy(BARS[idx], 0, bars, k * 8, 7);
        }
        return bars;
    }

    public static String calculateChecksum(String code) {
        if (code.length() < 2) {
            return code;
        }
        String text = code.toUpperCase();
        int sum = 0;
        int len = text.length();
        for (int k = 0; k < len; ++k) {
            sum += CHARS.indexOf(text.charAt(k));
        }
        sum = (sum + 15) / 16 * 16 - sum;
        return code.substring(0, len - 1) + CHARS.charAt(sum) + code.substring(len - 1);
    }

    @Override
    public Rectangle getBarcodeSize() {
        float fontX = 0.0f;
        float fontY = 0.0f;
        String text = this.code;
        if (this.generateChecksum && this.checksumText) {
            text = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            text = text.substring(1, text.length() - 1);
        }
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.getDescender() : -this.baseline + this.size;
            fontX = this.font.getWidth(this.altText != null ? this.altText : text, this.size);
        }
        text = this.code;
        if (this.generateChecksum) {
            text = BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] bars = BarcodeCodabar.getBarsCodabar(text);
        int wide = 0;
        for (int k = 0; k < bars.length; ++k) {
            wide += bars[k];
        }
        int narrow = bars.length - wide;
        float fullWidth = this.x * ((float)narrow + (float)wide * this.n);
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.colors.Color barColor, com.itextpdf.kernel.colors.Color textColor) {
        String fullCode = this.code;
        if (this.generateChecksum && this.checksumText) {
            fullCode = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            fullCode = fullCode.substring(1, fullCode.length() - 1);
        }
        float fontX = 0.0f;
        if (this.font != null) {
            fullCode = this.altText != null ? this.altText : fullCode;
            fontX = this.font.getWidth(fullCode, this.size);
        }
        byte[] bars = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int wide = 0;
        for (int k = 0; k < bars.length; ++k) {
            wide += bars[k];
        }
        int narrow = bars.length - wide;
        float fullWidth = this.x * ((float)narrow + (float)wide * this.n);
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 1: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.getDescender();
                barStartY = textStartY + this.baseline;
            }
        }
        boolean print = true;
        if (barColor != null) {
            canvas.setFillColor(barColor);
        }
        for (int k = 0; k < bars.length; ++k) {
            float w;
            float f = w = bars[k] == 0 ? this.x : this.x * this.n;
            if (print) {
                canvas.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
            }
            print = !print;
            barStartX += w;
        }
        canvas.fill();
        if (this.font != null) {
            if (textColor != null) {
                canvas.setFillColor(textColor);
            }
            canvas.beginText();
            canvas.setFontAndSize(this.font, this.size);
            canvas.setTextMatrix(textStartX, textStartY);
            canvas.showText(fullCode);
            canvas.endText();
        }
        return this.getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color foreground, Color background) {
        int k;
        int f = foreground == null ? this.DEFAULT_BAR_FOREGROUND_COLOR.getRGB() : foreground.getRGB();
        int g = background == null ? this.DEFAULT_BAR_BACKGROUND_COLOR.getRGB() : background.getRGB();
        Canvas canvas = new Canvas();
        byte[] bars = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int wide = 0;
        for (int k2 = 0; k2 < bars.length; ++k2) {
            wide += bars[k2];
        }
        int narrow = bars.length - wide;
        int fullWidth = narrow + wide * (int)this.n;
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[fullWidth * height];
        for (k = 0; k < bars.length; ++k) {
            int w = bars[k] == 0 ? 1 : (int)this.n;
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            for (int j = 0; j < w; ++j) {
                pix[ptr++] = c;
            }
        }
        for (k = fullWidth; k < pix.length; k += fullWidth) {
            System.arraycopy(pix, 0, pix, k, fullWidth);
        }
        return canvas.createImage(new MemoryImageSource(fullWidth, height, pix, 0, fullWidth));
    }
}

