/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.downloads.tbird;

import com.google.common.io.ByteStreams;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.bluemind.hornetq.client.Shared;
import net.bluemind.system.api.SysConfKeys;
import net.bluemind.ui.settings.downloads.tbird.Activator;
import org.eclipse.core.runtime.FileLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBirdDownloadHandlerWebExt
implements Handler<HttpServerRequest> {
    private static final Logger logger = LoggerFactory.getLogger(TBirdDownloadHandlerWebExt.class);

    public static String getExternalUrl() {
        String string = Optional.ofNullable((String)Shared.mapSysconf().get((Object)SysConfKeys.external_url.name())).orElse("configure.your.external.url");
        return string.trim();
    }

    public void handle(HttpServerRequest httpServerRequest) {
        String string = TBirdDownloadHandlerWebExt.getExternalUrl();
        try {
            Buffer buffer = this.repack(string);
            httpServerRequest.response().setStatusCode(200);
            httpServerRequest.response().headers().add("Content-Disposition", "attachment; filename=bm-connector-thunderbird-webext.xpi");
            httpServerRequest.response().headers().add("Content-Type", "application/x-download");
            httpServerRequest.response().end(buffer);
        }
        catch (IOException iOException) {
            logger.error("error during generating file", (Throwable)iOException);
            httpServerRequest.response().setStatusCode(500);
            httpServerRequest.response().end("error during generating file " + iOException.getMessage());
        }
    }

    private Buffer repack(String string) throws IOException {
        URL uRL = Activator.bundle.getResource("web-resources");
        URL uRL2 = FileLocator.toFileURL((URL)uRL);
        File file = new File(uRL2.getFile(), "downloads/tbird-webext.xpi");
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipFile zipFile = new ZipFile(file.getAbsolutePath());){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    continue;
                }
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                if (zipEntry.getName().endsWith("manifest.json")) {
                    this.replaceInstallJson("https://" + string + "/settings/settings/download/updateJson-webext", zipFile.getInputStream(zipEntry), zipOutputStream);
                } else if (zipEntry.getName().endsWith("content/api/DefaultPrefs/defaultprefs-impl.js")) {
                    this.replacePreferences("https://" + string, zipFile.getInputStream(zipEntry), zipOutputStream);
                } else {
                    ByteStreams.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.putNextEntry(new ZipEntry("content/certs/cacert.pem"));
            this.addCaCert(zipOutputStream);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            return Buffer.buffer((byte[])byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void replacePreferences(String string, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        String string2 = new String(ByteStreams.toByteArray((InputStream)inputStream));
        String[] stringArray = string2.split("\n");
        Object object = "";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            object = string3.contains("setDefaultPref(\"extensions.bm.server\"") ? (String)object + "setDefaultPref(\"extensions.bm.server\", \"" + string + "\");\r\n" : (String)object + string3 + "\r\n";
            ++n2;
        }
        ByteStreams.copy((InputStream)new ByteArrayInputStream(((String)object).getBytes()), (OutputStream)zipOutputStream);
    }

    private void addCaCert(OutputStream outputStream) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fileInputStream = new FileInputStream(new File("/var/lib/bm-ca/cacert.pem"));){
            ByteStreams.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void replaceInstallJson(String string, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        String string2 = new String(ByteStreams.toByteArray((InputStream)inputStream));
        String[] stringArray = string2.split("\n");
        Object object = "";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            object = string3.contains("update_url") ? (String)object + "\"update_url\": \"" + string + "\"\r\n" : (String)object + string3 + "\r\n";
            ++n2;
        }
        ByteStreams.copy((InputStream)new ByteArrayInputStream(((String)object).getBytes()), (OutputStream)zipOutputStream);
    }
}

