/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.contact.handlers;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.bluemind.addressbook.api.IAddressBookPromise;
import net.bluemind.addressbook.api.IAddressBooksPromise;
import net.bluemind.addressbook.api.VCardQuery;
import net.bluemind.core.container.api.IContainerManagementPromise;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxPromiseServiceProvider;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodules.contact.handlers.VCardStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportVCardHandler
implements Handler<HttpServerRequest>,
NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(ExportVCardHandler.class);
    private HttpClientProvider prov;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void handle(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.params().get("containerUid");
        String string2 = httpServerRequest.params().get("tagUid");
        MultiMap multiMap = httpServerRequest.headers();
        String string3 = multiMap.get("BMSessionId");
        VertxPromiseServiceProvider vertxPromiseServiceProvider = new VertxPromiseServiceProvider(this.prov, locator, string3);
        if (string != null) {
            this.exportByContainer(httpServerRequest, string, vertxPromiseServiceProvider);
        } else {
            this.exportByTag(httpServerRequest, string2, vertxPromiseServiceProvider);
        }
    }

    private void handleException(HttpServerRequest httpServerRequest) {
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.setStatusCode(500);
        httpServerResponse.end();
    }

    private void exportByTag(HttpServerRequest httpServerRequest, String string, VertxPromiseServiceProvider vertxPromiseServiceProvider) {
        VCardQuery vCardQuery = VCardQuery.create((String)("value.explanatory.categories.itemUid:" + string));
        IAddressBooksPromise iAddressBooksPromise = (IAddressBooksPromise)vertxPromiseServiceProvider.instance(IAddressBooksPromise.class, new String[0]);
        HashMap hashMap = new HashMap();
        CompletableFuture completableFuture = iAddressBooksPromise.search(vCardQuery);
        completableFuture.thenAccept(listResult -> {
            listResult.values.forEach(itemContainerValue -> {
                String string = itemContainerValue.containerUid;
                String string2 = itemContainerValue.uid;
                List list = null;
                list = hashMap.containsKey(string) ? (List)hashMap.get(string) : new ArrayList();
                list.add(string2);
                hashMap.put(string, list);
            });
            this.prepareResponse(httpServerRequest, string + ".vcf");
            this.stream(httpServerRequest, (IServiceProvider)vertxPromiseServiceProvider, hashMap);
        });
        completableFuture.exceptionally(throwable -> {
            this.handleException(httpServerRequest);
            return null;
        });
    }

    private void exportByContainer(HttpServerRequest httpServerRequest, String string, VertxPromiseServiceProvider vertxPromiseServiceProvider) {
        HashMap hashMap = new HashMap();
        IContainerManagementPromise iContainerManagementPromise = (IContainerManagementPromise)vertxPromiseServiceProvider.instance(IContainerManagementPromise.class, new String[]{string});
        IAddressBookPromise iAddressBookPromise = (IAddressBookPromise)vertxPromiseServiceProvider.instance(IAddressBookPromise.class, new String[]{string});
        CompletableFuture completableFuture = iContainerManagementPromise.getDescriptor();
        CompletableFuture completableFuture2 = iAddressBookPromise.allUids();
        CompletionStage completionStage = completableFuture2.thenAcceptBoth((CompletionStage)completableFuture, (list, containerDescriptor) -> {
            this.prepareResponse(httpServerRequest, containerDescriptor.name + "_" + string + ".vcf");
            hashMap.put(string, list);
            this.stream(httpServerRequest, (IServiceProvider)vertxPromiseServiceProvider, hashMap);
        });
        ((CompletableFuture)completionStage).exceptionally(throwable -> {
            this.handleException(httpServerRequest);
            return null;
        });
    }

    private void stream(HttpServerRequest httpServerRequest, IServiceProvider iServiceProvider, Map<String, List<String>> map) {
        if (logger.isDebugEnabled()) {
            for (String object2 : map.keySet()) {
                logger.debug("exporting container {} containing {} vcards", (Object)object2, (Object)map.get(object2).size());
            }
        }
        VCardStream vCardStream = new VCardStream(iServiceProvider, map);
        vCardStream.pipeTo((WriteStream)httpServerRequest.response());
    }

    private void prepareResponse(HttpServerRequest httpServerRequest, String string) {
        httpServerRequest.response().headers().add("Content-Disposition", "attachment; filename=\"" + string + "\"");
        httpServerRequest.response().setChunked(true).setStatusCode(200);
    }

    public void setVertx(Vertx vertx) {
        this.prov = new HttpClientProvider(vertx);
    }
}

