/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.OrderedBytes;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;

public class SessionKeySchema
implements SegmentedBytesStore.KeySchema {
    private static final int SUFFIX_SIZE = 16;
    private static final byte[] MIN_SUFFIX = new byte[16];

    public static int keyByteLength(Bytes key) {
        return (key == null ? 0 : key.get().length) + 16;
    }

    @Override
    public Bytes upperRangeFixedSize(Bytes key, long to) {
        Windowed<Bytes> sessionKey = SessionKeySchema.upperRangeFixedWindow(key, to);
        return SessionKeySchema.toBinary(sessionKey);
    }

    public static <K> Windowed<K> upperRangeFixedWindow(K key, long to) {
        return new Windowed<K>(key, new SessionWindow(to, Long.MAX_VALUE));
    }

    @Override
    public Bytes lowerRangeFixedSize(Bytes key, long from) {
        Windowed<Bytes> sessionKey = SessionKeySchema.lowerRangeFixedWindow(key, from);
        return SessionKeySchema.toBinary(sessionKey);
    }

    public static <K> Windowed<K> lowerRangeFixedWindow(K key, long from) {
        return new Windowed<K>(key, new SessionWindow(0L, Math.max(0L, from)));
    }

    @Override
    public Bytes upperRange(Bytes key, long to) {
        if (key == null) {
            return null;
        }
        byte[] maxSuffix = ByteBuffer.allocate(16).putLong(Long.MAX_VALUE).putLong(to).array();
        return OrderedBytes.upperRange(key, maxSuffix);
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        if (key == null) {
            return null;
        }
        return OrderedBytes.lowerRange(key, MIN_SUFFIX);
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return SessionKeySchema.extractEndTimestamp(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to, boolean forward) {
        return iterator -> {
            while (iterator.hasNext()) {
                Bytes bytes = (Bytes)iterator.peekNextKey();
                Windowed<Bytes> windowedKey = SessionKeySchema.from(bytes);
                if (!(binaryKeyFrom != null && windowedKey.key().compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && windowedKey.key().compareTo(binaryKeyTo) > 0 || windowedKey.window().end() < from || windowedKey.window().start() > to)) {
                    return true;
                }
                iterator.next();
            }
            return false;
        };
    }

    @Override
    public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to, boolean forward) {
        return segments.segments(from, Long.MAX_VALUE, forward);
    }

    private static <K> K extractKey(byte[] binaryKey, Deserializer<K> deserializer, String topic) {
        return deserializer.deserialize(topic, SessionKeySchema.extractKeyBytes(binaryKey));
    }

    static byte[] extractKeyBytes(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 16];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return bytes;
    }

    static long extractEndTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 16);
    }

    static long extractStartTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8);
    }

    static Window extractWindow(byte[] binaryKey) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8);
        long end = buffer.getLong(binaryKey.length - 16);
        return new SessionWindow(start, end);
    }

    public static <K> Windowed<K> from(byte[] binaryKey, Deserializer<K> keyDeserializer, String topic) {
        K key = SessionKeySchema.extractKey(binaryKey, keyDeserializer, topic);
        Window window = SessionKeySchema.extractWindow(binaryKey);
        return new Windowed<K>(key, window);
    }

    public static Windowed<Bytes> from(Bytes bytesKey) {
        byte[] binaryKey = bytesKey.get();
        Window window = SessionKeySchema.extractWindow(binaryKey);
        return new Windowed<Bytes>(Bytes.wrap(SessionKeySchema.extractKeyBytes(binaryKey)), window);
    }

    public static <K> Windowed<K> from(Windowed<Bytes> keyBytes, Deserializer<K> keyDeserializer, String topic) {
        K key = keyDeserializer.deserialize(topic, keyBytes.key().get());
        return new Windowed<K>(key, keyBytes.window());
    }

    public static <K> byte[] toBinary(Windowed<K> sessionKey, Serializer<K> serializer, String topic) {
        byte[] bytes = serializer.serialize(topic, sessionKey.key());
        return SessionKeySchema.toBinary(Bytes.wrap(bytes), sessionKey.window().start(), sessionKey.window().end()).get();
    }

    public static Bytes toBinary(Windowed<Bytes> sessionKey) {
        return SessionKeySchema.toBinary(sessionKey.key(), sessionKey.window().start(), sessionKey.window().end());
    }

    public static Bytes toBinary(Bytes key, long startTime, long endTime) {
        ByteBuffer buf = ByteBuffer.allocate(SessionKeySchema.keyByteLength(key));
        SessionKeySchema.writeBinary(buf, key, startTime, endTime);
        return Bytes.wrap(buf.array());
    }

    public static void writeBinary(ByteBuffer buf, Windowed<Bytes> sessionKey) {
        SessionKeySchema.writeBinary(buf, sessionKey.key(), sessionKey.window().start(), sessionKey.window().end());
    }

    public static void writeBinary(ByteBuffer buf, Bytes key, long startTime, long endTime) {
        buf.put(key.get());
        buf.putLong(endTime);
        buf.putLong(startTime);
    }
}

