/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.BufferKey;
import org.apache.kafka.streams.state.internals.BufferValue;
import org.apache.kafka.streams.state.internals.Maybe;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;

public class RocksDBTimeOrderedKeyValueBuffer<K, V>
implements TimeOrderedKeyValueBuffer<K, V, V> {
    private static final BytesSerializer KEY_SERIALIZER = new BytesSerializer();
    private static final ByteArraySerializer VALUE_SERIALIZER = new ByteArraySerializer();
    private final long gracePeriod;
    private final RocksDBTimeOrderedKeyValueBytesStore store;
    private long bufferSize;
    private long minTimestamp;
    private int numRecords;
    private Serde<K> keySerde;
    private Serde<V> valueSerde;
    private final String topic;
    private int seqnum;
    private final boolean loggingEnabled;
    private int partition;
    private String changelogTopic;
    private InternalProcessorContext context;
    private boolean minValid;

    public RocksDBTimeOrderedKeyValueBuffer(RocksDBTimeOrderedKeyValueBytesStore store, Duration gracePeriod, String topic, boolean loggingEnabled) {
        this.store = store;
        this.gracePeriod = gracePeriod.toMillis();
        this.minTimestamp = store.minTimestamp();
        this.minValid = false;
        this.numRecords = 0;
        this.bufferSize = 0L;
        this.seqnum = 0;
        this.topic = topic;
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public void setSerdesIfNull(SerdeGetter getter) {
        this.keySerde = this.keySerde == null ? getter.keySerde() : this.keySerde;
        this.valueSerde = this.valueSerde == null ? getter.valueSerde() : this.valueSerde;
    }

    private long observedStreamTime() {
        return this.store.observedStreamTime;
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.store.init(context, root);
        this.context = ProcessorContextUtils.asInternalProcessorContext(context);
        this.partition = context.taskId().partition();
        if (this.loggingEnabled) {
            this.changelogTopic = ProcessorContextUtils.changelogFor(context, this.name(), Boolean.TRUE);
        }
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.store.init(context, root);
        this.context = ProcessorContextUtils.asInternalProcessorContext(context);
        this.partition = context.taskId().partition();
        if (this.loggingEnabled) {
            this.changelogTopic = ProcessorContextUtils.changelogFor(context, this.name(), Boolean.TRUE);
        }
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return this.store.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    @Override
    public void evictWhile(Supplier<Boolean> predicate, Consumer<TimeOrderedKeyValueBuffer.Eviction<K, V>> callback) {
        if (predicate.get().booleanValue()) {
            long start = 0L;
            if (this.minValid) {
                start = this.minTimestamp();
            }
            try (KeyValueIterator<Bytes, byte[]> iterator = this.store.fetchAll(start, this.observedStreamTime() - this.gracePeriod);){
                while (iterator.hasNext() && predicate.get().booleanValue()) {
                    KeyValue keyValue = (KeyValue)iterator.next();
                    BufferValue bufferValue = BufferValue.deserialize(ByteBuffer.wrap((byte[])keyValue.value));
                    K key = this.keySerde.deserializer().deserialize(this.topic, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.extractStoreKeyBytes(((Bytes)keyValue.key).get()));
                    if (bufferValue.context().timestamp() < this.minTimestamp && this.minValid) {
                        throw new IllegalStateException("minTimestamp [" + this.minTimestamp + "] did not match the actual min timestamp [" + bufferValue.context().timestamp() + "]");
                    }
                    this.minTimestamp = bufferValue.context().timestamp();
                    this.minValid = true;
                    V value = this.valueSerde.deserializer().deserialize(this.topic, bufferValue.newValue());
                    callback.accept(new TimeOrderedKeyValueBuffer.Eviction<K, V>(key, value, bufferValue.context()));
                    this.store.remove((Bytes)keyValue.key);
                    if (this.loggingEnabled) {
                        this.logTombstone((Bytes)keyValue.key);
                    }
                    --this.numRecords;
                    this.bufferSize -= RocksDBTimeOrderedKeyValueBuffer.computeRecordSize((Bytes)keyValue.key, bufferValue);
                }
                this.minTimestamp = this.numRecords == 0 ? Long.MAX_VALUE : this.observedStreamTime() - this.gracePeriod + 1L;
            }
        }
    }

    @Override
    public Maybe<ValueAndTimestamp<V>> priorValueForBuffered(K key) {
        return Maybe.undefined();
    }

    @Override
    public boolean put(long time, Record<K, V> record, ProcessorRecordContext recordContext) {
        Objects.requireNonNull(record.value(), "value cannot be null");
        Objects.requireNonNull(record.key(), "key cannot be null");
        Objects.requireNonNull(recordContext, "recordContext cannot be null");
        if (this.observedStreamTime() - this.gracePeriod > record.timestamp()) {
            return false;
        }
        this.maybeUpdateSeqnumForDups();
        Bytes serializedKey = Bytes.wrap(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(this.keySerde.serializer().serialize(this.topic, record.key()), record.timestamp(), this.seqnum).get());
        byte[] valueBytes = this.valueSerde.serializer().serialize(this.topic, record.value());
        BufferValue buffered = new BufferValue(null, null, valueBytes, recordContext);
        this.store.put(serializedKey, buffered.serialize(0).array());
        if (this.loggingEnabled) {
            BufferKey key = new BufferKey(0L, serializedKey);
            this.logValue(serializedKey, key, buffered);
        }
        this.bufferSize += RocksDBTimeOrderedKeyValueBuffer.computeRecordSize(serializedKey, buffered);
        ++this.numRecords;
        this.minTimestamp = Math.min(this.minTimestamp(), record.timestamp());
        return true;
    }

    @Override
    public int numRecords() {
        return this.numRecords;
    }

    @Override
    public long bufferSize() {
        return this.bufferSize;
    }

    @Override
    public long minTimestamp() {
        return this.minTimestamp;
    }

    private static long computeRecordSize(Bytes key, BufferValue value) {
        long size = 0L;
        size += (long)key.get().length;
        if (value != null) {
            size += value.residentMemorySizeEstimate();
        }
        return size;
    }

    private void maybeUpdateSeqnumForDups() {
        this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
    }

    private void logValue(Bytes key, BufferKey bufferKey, BufferValue value) {
        int sizeOfBufferTime = 8;
        ByteBuffer buffer = value.serialize(8);
        buffer.putLong(bufferKey.time());
        byte[] array = buffer.array();
        ((RecordCollector.Supplier)((Object)this.context)).recordCollector().send(this.changelogTopic, key, array, null, this.partition, null, KEY_SERIALIZER, VALUE_SERIALIZER, null, null);
    }

    private void logTombstone(Bytes key) {
        ((RecordCollector.Supplier)((Object)this.context)).recordCollector().send(this.changelogTopic, key, null, null, this.partition, null, KEY_SERIALIZER, VALUE_SERIALIZER, null, null);
    }

    public static class Builder<K, V>
    implements StoreBuilder<TimeOrderedKeyValueBuffer<K, V, V>> {
        private final String storeName;
        private boolean loggingEnabled = true;
        private Map<String, String> logConfig = new HashMap<String, String>();
        private final Duration grace;
        private final String topic;

        public Builder(String storeName, Duration grace, String topic) {
            this.storeName = storeName;
            this.grace = grace;
            this.topic = topic;
        }

        @Override
        public StoreBuilder<TimeOrderedKeyValueBuffer<K, V, V>> withCachingEnabled() {
            return this;
        }

        @Override
        public StoreBuilder<TimeOrderedKeyValueBuffer<K, V, V>> withCachingDisabled() {
            return this;
        }

        @Override
        public StoreBuilder<TimeOrderedKeyValueBuffer<K, V, V>> withLoggingEnabled(Map<String, String> config) {
            this.logConfig = config;
            return this;
        }

        @Override
        public StoreBuilder<TimeOrderedKeyValueBuffer<K, V, V>> withLoggingDisabled() {
            this.loggingEnabled = false;
            return this;
        }

        @Override
        public TimeOrderedKeyValueBuffer<K, V, V> build() {
            return new RocksDBTimeOrderedKeyValueBuffer(new RocksDBTimeOrderedKeyValueBytesStoreSupplier(this.storeName).get(), this.grace, this.topic, this.loggingEnabled);
        }

        @Override
        public Map<String, String> logConfig() {
            return this.loggingEnabled() ? Collections.unmodifiableMap(this.logConfig) : Collections.emptyMap();
        }

        @Override
        public boolean loggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public String name() {
            return this.storeName;
        }
    }
}

