/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collection;
import java.util.List;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractWalFilter;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.ConcurrentTaskLimiter;
import org.rocksdb.DBOptions;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.PrepopulateBlobCache;
import org.rocksdb.RateLimiter;
import org.rocksdb.SstFileManager;
import org.rocksdb.SstPartitionerFactory;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WalFilter;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter
extends Options {
    private static final Logger log = LoggerFactory.getLogger(RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class);
    private final DBOptions dbOptions;
    private final ColumnFamilyOptions columnFamilyOptions;

    RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        this.dbOptions = dbOptions;
        this.columnFamilyOptions = columnFamilyOptions;
    }

    @Override
    public Options setIncreaseParallelism(int totalThreads) {
        this.dbOptions.setIncreaseParallelism(totalThreads);
        return this;
    }

    @Override
    public Options setCreateIfMissing(boolean flag) {
        this.dbOptions.setCreateIfMissing(flag);
        return this;
    }

    @Override
    public Options setCreateMissingColumnFamilies(boolean flag) {
        this.dbOptions.setCreateMissingColumnFamilies(flag);
        return this;
    }

    @Override
    public Options setEnv(Env env) {
        this.dbOptions.setEnv(env);
        return this;
    }

    @Override
    public Env getEnv() {
        return this.dbOptions.getEnv();
    }

    @Override
    public Options prepareForBulkLoad() {
        super.prepareForBulkLoad();
        return this;
    }

    @Override
    public boolean createIfMissing() {
        return this.dbOptions.createIfMissing();
    }

    @Override
    public boolean createMissingColumnFamilies() {
        return this.dbOptions.createMissingColumnFamilies();
    }

    @Override
    public Options optimizeForSmallDb() {
        this.dbOptions.optimizeForSmallDb();
        this.columnFamilyOptions.optimizeForSmallDb();
        return this;
    }

    @Override
    public Options optimizeForPointLookup(long blockCacheSizeMb) {
        this.columnFamilyOptions.optimizeForPointLookup(blockCacheSizeMb);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction() {
        this.columnFamilyOptions.optimizeLevelStyleCompaction();
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeLevelStyleCompaction(memtableMemoryBudget);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction() {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction();
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction(memtableMemoryBudget);
        return this;
    }

    @Override
    public Options setComparator(BuiltinComparator builtinComparator) {
        this.columnFamilyOptions.setComparator(builtinComparator);
        return this;
    }

    @Override
    public Options setComparator(AbstractComparator comparator) {
        this.columnFamilyOptions.setComparator(comparator);
        return this;
    }

    @Override
    public Options setMergeOperatorName(String name) {
        this.columnFamilyOptions.setMergeOperatorName(name);
        return this;
    }

    @Override
    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.columnFamilyOptions.setMergeOperator(mergeOperator);
        return this;
    }

    @Override
    public Options setWriteBufferSize(long writeBufferSize) {
        this.columnFamilyOptions.setWriteBufferSize(writeBufferSize);
        return this;
    }

    @Override
    public long writeBufferSize() {
        return this.columnFamilyOptions.writeBufferSize();
    }

    @Override
    public Options setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        this.columnFamilyOptions.setMaxWriteBufferNumber(maxWriteBufferNumber);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        return this.columnFamilyOptions.maxWriteBufferNumber();
    }

    @Override
    public boolean errorIfExists() {
        return this.dbOptions.errorIfExists();
    }

    @Override
    public Options setErrorIfExists(boolean errorIfExists) {
        this.dbOptions.setErrorIfExists(errorIfExists);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        boolean dbOptionsParanoidChecks;
        boolean columnFamilyParanoidFileChecks = this.columnFamilyOptions.paranoidFileChecks();
        if (columnFamilyParanoidFileChecks != (dbOptionsParanoidChecks = this.dbOptions.paranoidChecks())) {
            throw new IllegalStateException("Config for paranoid checks for RockDB and ColumnFamilies should be the same.");
        }
        return dbOptionsParanoidChecks;
    }

    @Override
    public Options setParanoidChecks(boolean paranoidChecks) {
        this.columnFamilyOptions.paranoidFileChecks();
        this.dbOptions.setParanoidChecks(paranoidChecks);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        return this.dbOptions.maxOpenFiles();
    }

    @Override
    public Options setMaxFileOpeningThreads(int maxFileOpeningThreads) {
        this.dbOptions.setMaxFileOpeningThreads(maxFileOpeningThreads);
        return this;
    }

    @Override
    public int maxFileOpeningThreads() {
        return this.dbOptions.maxFileOpeningThreads();
    }

    @Override
    public Options setMaxTotalWalSize(long maxTotalWalSize) {
        this.logIgnoreWalOption("maxTotalWalSize");
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        return this.dbOptions.maxTotalWalSize();
    }

    @Override
    public Options setMaxOpenFiles(int maxOpenFiles) {
        this.dbOptions.setMaxOpenFiles(maxOpenFiles);
        return this;
    }

    @Override
    public boolean useFsync() {
        return this.dbOptions.useFsync();
    }

    @Override
    public Options setUseFsync(boolean useFsync) {
        this.dbOptions.setUseFsync(useFsync);
        return this;
    }

    @Override
    public Options setDbPaths(Collection<DbPath> dbPaths) {
        this.dbOptions.setDbPaths((Collection)dbPaths);
        return this;
    }

    @Override
    public List<DbPath> dbPaths() {
        return this.dbOptions.dbPaths();
    }

    @Override
    public String dbLogDir() {
        return this.dbOptions.dbLogDir();
    }

    @Override
    public Options setDbLogDir(String dbLogDir) {
        this.dbOptions.setDbLogDir(dbLogDir);
        return this;
    }

    @Override
    public String walDir() {
        return this.dbOptions.walDir();
    }

    @Override
    public Options setWalDir(String walDir) {
        this.logIgnoreWalOption("walDir");
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        return this.dbOptions.deleteObsoleteFilesPeriodMicros();
    }

    @Override
    public Options setDeleteObsoleteFilesPeriodMicros(long micros) {
        this.dbOptions.setDeleteObsoleteFilesPeriodMicros(micros);
        return this;
    }

    @Override
    @Deprecated
    public int maxBackgroundCompactions() {
        return this.dbOptions.maxBackgroundCompactions();
    }

    @Override
    public Options setStatistics(Statistics statistics) {
        this.dbOptions.setStatistics(statistics);
        return this;
    }

    @Override
    public Statistics statistics() {
        return this.dbOptions.statistics();
    }

    @Deprecated
    public void setBaseBackgroundCompactions(int baseBackgroundCompactions) {
        String message = "This method has been removed from the underlying RocksDB. It was not affecting compaction even in earlier versions. It is currently a no-op method. RocksDB decides the number of background compactions based on the maxBackgroundJobs(...) method";
        log.warn("This method has been removed from the underlying RocksDB. It was not affecting compaction even in earlier versions. It is currently a no-op method. RocksDB decides the number of background compactions based on the maxBackgroundJobs(...) method");
    }

    @Deprecated
    public int baseBackgroundCompactions() {
        String message = "This method has been removed from the underlying RocksDB. It is currently a no-op method which returns a default value of -1.";
        log.warn("This method has been removed from the underlying RocksDB. It is currently a no-op method which returns a default value of -1.");
        return -1;
    }

    @Override
    @Deprecated
    public Options setMaxBackgroundCompactions(int maxBackgroundCompactions) {
        this.dbOptions.setMaxBackgroundCompactions(maxBackgroundCompactions);
        return this;
    }

    @Override
    public Options setMaxSubcompactions(int maxSubcompactions) {
        this.dbOptions.setMaxSubcompactions(maxSubcompactions);
        return this;
    }

    @Override
    public int maxSubcompactions() {
        return this.dbOptions.maxSubcompactions();
    }

    @Override
    @Deprecated
    public int maxBackgroundFlushes() {
        return this.dbOptions.maxBackgroundFlushes();
    }

    @Override
    @Deprecated
    public Options setMaxBackgroundFlushes(int maxBackgroundFlushes) {
        this.dbOptions.setMaxBackgroundFlushes(maxBackgroundFlushes);
        return this;
    }

    @Override
    public int maxBackgroundJobs() {
        return this.dbOptions.maxBackgroundJobs();
    }

    @Override
    public Options setMaxBackgroundJobs(int maxBackgroundJobs) {
        this.dbOptions.setMaxBackgroundJobs(maxBackgroundJobs);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        return this.dbOptions.maxLogFileSize();
    }

    @Override
    public Options setMaxLogFileSize(long maxLogFileSize) {
        this.dbOptions.setMaxLogFileSize(maxLogFileSize);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        return this.dbOptions.logFileTimeToRoll();
    }

    @Override
    public Options setLogFileTimeToRoll(long logFileTimeToRoll) {
        this.dbOptions.setLogFileTimeToRoll(logFileTimeToRoll);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        return this.dbOptions.keepLogFileNum();
    }

    @Override
    public Options setKeepLogFileNum(long keepLogFileNum) {
        this.dbOptions.setKeepLogFileNum(keepLogFileNum);
        return this;
    }

    @Override
    public Options setRecycleLogFileNum(long recycleLogFileNum) {
        this.dbOptions.setRecycleLogFileNum(recycleLogFileNum);
        return this;
    }

    @Override
    public long recycleLogFileNum() {
        return this.dbOptions.recycleLogFileNum();
    }

    @Override
    public long maxManifestFileSize() {
        return this.dbOptions.maxManifestFileSize();
    }

    @Override
    public Options setMaxManifestFileSize(long maxManifestFileSize) {
        this.dbOptions.setMaxManifestFileSize(maxManifestFileSize);
        return this;
    }

    @Override
    public Options setMaxTableFilesSizeFIFO(long maxTableFilesSize) {
        this.columnFamilyOptions.setMaxTableFilesSizeFIFO(maxTableFilesSize);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.columnFamilyOptions.maxTableFilesSizeFIFO();
    }

    @Override
    public int tableCacheNumshardbits() {
        return this.dbOptions.tableCacheNumshardbits();
    }

    @Override
    public Options setTableCacheNumshardbits(int tableCacheNumshardbits) {
        this.dbOptions.setTableCacheNumshardbits(tableCacheNumshardbits);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        return this.dbOptions.walTtlSeconds();
    }

    @Override
    public Options setWalTtlSeconds(long walTtlSeconds) {
        this.logIgnoreWalOption("walTtlSeconds");
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        return this.dbOptions.walSizeLimitMB();
    }

    @Override
    public Options setWalSizeLimitMB(long sizeLimitMB) {
        this.logIgnoreWalOption("walSizeLimitMB");
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        return this.dbOptions.manifestPreallocationSize();
    }

    @Override
    public Options setManifestPreallocationSize(long size) {
        this.dbOptions.setManifestPreallocationSize(size);
        return this;
    }

    @Override
    public Options setUseDirectReads(boolean useDirectReads) {
        this.dbOptions.setUseDirectReads(useDirectReads);
        return this;
    }

    @Override
    public boolean useDirectReads() {
        return this.dbOptions.useDirectReads();
    }

    @Override
    public Options setUseDirectIoForFlushAndCompaction(boolean useDirectIoForFlushAndCompaction) {
        this.dbOptions.setUseDirectIoForFlushAndCompaction(useDirectIoForFlushAndCompaction);
        return this;
    }

    @Override
    public boolean useDirectIoForFlushAndCompaction() {
        return this.dbOptions.useDirectIoForFlushAndCompaction();
    }

    @Override
    public Options setAllowFAllocate(boolean allowFAllocate) {
        this.dbOptions.setAllowFAllocate(allowFAllocate);
        return this;
    }

    @Override
    public boolean allowFAllocate() {
        return this.dbOptions.allowFAllocate();
    }

    @Override
    public boolean allowMmapReads() {
        return this.dbOptions.allowMmapReads();
    }

    @Override
    public Options setAllowMmapReads(boolean allowMmapReads) {
        this.dbOptions.setAllowMmapReads(allowMmapReads);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        return this.dbOptions.allowMmapWrites();
    }

    @Override
    public Options setAllowMmapWrites(boolean allowMmapWrites) {
        this.dbOptions.setAllowMmapWrites(allowMmapWrites);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        return this.dbOptions.isFdCloseOnExec();
    }

    @Override
    public Options setIsFdCloseOnExec(boolean isFdCloseOnExec) {
        this.dbOptions.setIsFdCloseOnExec(isFdCloseOnExec);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        return this.dbOptions.statsDumpPeriodSec();
    }

    @Override
    public Options setStatsDumpPeriodSec(int statsDumpPeriodSec) {
        this.dbOptions.setStatsDumpPeriodSec(statsDumpPeriodSec);
        return this;
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.dbOptions.adviseRandomOnOpen();
    }

    @Override
    public Options setAdviseRandomOnOpen(boolean adviseRandomOnOpen) {
        this.dbOptions.setAdviseRandomOnOpen(adviseRandomOnOpen);
        return this;
    }

    @Override
    public Options setDbWriteBufferSize(long dbWriteBufferSize) {
        this.dbOptions.setDbWriteBufferSize(dbWriteBufferSize);
        return this;
    }

    @Override
    public long dbWriteBufferSize() {
        return this.dbOptions.dbWriteBufferSize();
    }

    @Override
    public Options setAccessHintOnCompactionStart(AccessHint accessHint) {
        this.dbOptions.setAccessHintOnCompactionStart(accessHint);
        return this;
    }

    @Override
    public AccessHint accessHintOnCompactionStart() {
        return this.dbOptions.accessHintOnCompactionStart();
    }

    @Deprecated
    public Options setNewTableReaderForCompactionInputs(boolean newTableReaderForCompactionInputs) {
        String message = "This method has been removed from the underlying RocksDB. It was not affecting compaction even in earlier versions. It is currently a no-op method.";
        log.warn("This method has been removed from the underlying RocksDB. It was not affecting compaction even in earlier versions. It is currently a no-op method.");
        return this;
    }

    @Deprecated
    public boolean newTableReaderForCompactionInputs() {
        String message = "This method has been removed from the underlying RocksDB. It is now a method which always returns false.";
        log.warn("This method has been removed from the underlying RocksDB. It is now a method which always returns false.");
        return false;
    }

    @Override
    public Options setCompactionReadaheadSize(long compactionReadaheadSize) {
        this.dbOptions.setCompactionReadaheadSize(compactionReadaheadSize);
        return this;
    }

    @Override
    public long compactionReadaheadSize() {
        return this.dbOptions.compactionReadaheadSize();
    }

    @Override
    public Options setRandomAccessMaxBufferSize(long randomAccessMaxBufferSize) {
        this.dbOptions.setRandomAccessMaxBufferSize(randomAccessMaxBufferSize);
        return this;
    }

    @Override
    public long randomAccessMaxBufferSize() {
        return this.dbOptions.randomAccessMaxBufferSize();
    }

    @Override
    public Options setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
        this.dbOptions.setWritableFileMaxBufferSize(writableFileMaxBufferSize);
        return this;
    }

    @Override
    public long writableFileMaxBufferSize() {
        return this.dbOptions.writableFileMaxBufferSize();
    }

    @Override
    public boolean useAdaptiveMutex() {
        return this.dbOptions.useAdaptiveMutex();
    }

    @Override
    public Options setUseAdaptiveMutex(boolean useAdaptiveMutex) {
        this.dbOptions.setUseAdaptiveMutex(useAdaptiveMutex);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.dbOptions.bytesPerSync();
    }

    @Override
    public Options setBytesPerSync(long bytesPerSync) {
        this.dbOptions.setBytesPerSync(bytesPerSync);
        return this;
    }

    @Override
    public Options setWalBytesPerSync(long walBytesPerSync) {
        this.logIgnoreWalOption("walBytesPerSync");
        return this;
    }

    @Override
    public long walBytesPerSync() {
        return this.dbOptions.walBytesPerSync();
    }

    @Override
    public Options setEnableThreadTracking(boolean enableThreadTracking) {
        this.dbOptions.setEnableThreadTracking(enableThreadTracking);
        return this;
    }

    @Override
    public boolean enableThreadTracking() {
        return this.dbOptions.enableThreadTracking();
    }

    @Override
    public Options setDelayedWriteRate(long delayedWriteRate) {
        this.dbOptions.setDelayedWriteRate(delayedWriteRate);
        return this;
    }

    @Override
    public long delayedWriteRate() {
        return this.dbOptions.delayedWriteRate();
    }

    @Override
    public Options setAllowConcurrentMemtableWrite(boolean allowConcurrentMemtableWrite) {
        this.dbOptions.setAllowConcurrentMemtableWrite(allowConcurrentMemtableWrite);
        return this;
    }

    @Override
    public boolean allowConcurrentMemtableWrite() {
        return this.dbOptions.allowConcurrentMemtableWrite();
    }

    @Override
    public Options setEnableWriteThreadAdaptiveYield(boolean enableWriteThreadAdaptiveYield) {
        this.dbOptions.setEnableWriteThreadAdaptiveYield(enableWriteThreadAdaptiveYield);
        return this;
    }

    @Override
    public boolean enableWriteThreadAdaptiveYield() {
        return this.dbOptions.enableWriteThreadAdaptiveYield();
    }

    @Override
    public Options setWriteThreadMaxYieldUsec(long writeThreadMaxYieldUsec) {
        this.dbOptions.setWriteThreadMaxYieldUsec(writeThreadMaxYieldUsec);
        return this;
    }

    @Override
    public long writeThreadMaxYieldUsec() {
        return this.dbOptions.writeThreadMaxYieldUsec();
    }

    @Override
    public Options setWriteThreadSlowYieldUsec(long writeThreadSlowYieldUsec) {
        this.dbOptions.setWriteThreadSlowYieldUsec(writeThreadSlowYieldUsec);
        return this;
    }

    @Override
    public long writeThreadSlowYieldUsec() {
        return this.dbOptions.writeThreadSlowYieldUsec();
    }

    @Override
    public Options setSkipStatsUpdateOnDbOpen(boolean skipStatsUpdateOnDbOpen) {
        this.dbOptions.setSkipStatsUpdateOnDbOpen(skipStatsUpdateOnDbOpen);
        return this;
    }

    @Override
    public boolean skipStatsUpdateOnDbOpen() {
        return this.dbOptions.skipStatsUpdateOnDbOpen();
    }

    @Override
    public Options setWalRecoveryMode(WALRecoveryMode walRecoveryMode) {
        this.logIgnoreWalOption("walRecoveryMode");
        return this;
    }

    @Override
    public WALRecoveryMode walRecoveryMode() {
        return this.dbOptions.walRecoveryMode();
    }

    @Override
    public Options setAllow2pc(boolean allow2pc) {
        this.dbOptions.setAllow2pc(allow2pc);
        return this;
    }

    @Override
    public boolean allow2pc() {
        return this.dbOptions.allow2pc();
    }

    @Override
    public Options setRowCache(Cache rowCache) {
        this.dbOptions.setRowCache(rowCache);
        return this;
    }

    @Override
    public Cache rowCache() {
        return this.dbOptions.rowCache();
    }

    @Override
    public Options setFailIfOptionsFileError(boolean failIfOptionsFileError) {
        this.dbOptions.setFailIfOptionsFileError(failIfOptionsFileError);
        return this;
    }

    @Override
    public boolean failIfOptionsFileError() {
        return this.dbOptions.failIfOptionsFileError();
    }

    @Override
    public Options setDumpMallocStats(boolean dumpMallocStats) {
        this.dbOptions.setDumpMallocStats(dumpMallocStats);
        return this;
    }

    @Override
    public boolean dumpMallocStats() {
        return this.dbOptions.dumpMallocStats();
    }

    @Override
    public Options setAvoidFlushDuringRecovery(boolean avoidFlushDuringRecovery) {
        this.dbOptions.setAvoidFlushDuringRecovery(avoidFlushDuringRecovery);
        return this;
    }

    @Override
    public boolean avoidFlushDuringRecovery() {
        return this.dbOptions.avoidFlushDuringRecovery();
    }

    @Override
    public Options setAvoidFlushDuringShutdown(boolean avoidFlushDuringShutdown) {
        this.dbOptions.setAvoidFlushDuringShutdown(avoidFlushDuringShutdown);
        return this;
    }

    @Override
    public boolean avoidFlushDuringShutdown() {
        return this.dbOptions.avoidFlushDuringShutdown();
    }

    @Override
    public MemTableConfig memTableConfig() {
        return this.columnFamilyOptions.memTableConfig();
    }

    @Override
    public Options setMemTableConfig(MemTableConfig config) {
        this.columnFamilyOptions.setMemTableConfig(config);
        return this;
    }

    @Override
    public Options setRateLimiter(RateLimiter rateLimiter) {
        this.dbOptions.setRateLimiter(rateLimiter);
        return this;
    }

    @Override
    public Options setSstFileManager(SstFileManager sstFileManager) {
        this.dbOptions.setSstFileManager(sstFileManager);
        return this;
    }

    @Override
    public Options setLogger(org.rocksdb.Logger logger) {
        this.dbOptions.setLogger(logger);
        return this;
    }

    @Override
    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.dbOptions.setInfoLogLevel(infoLogLevel);
        return this;
    }

    @Override
    public InfoLogLevel infoLogLevel() {
        return this.dbOptions.infoLogLevel();
    }

    @Override
    public String memTableFactoryName() {
        return this.columnFamilyOptions.memTableFactoryName();
    }

    @Override
    public TableFormatConfig tableFormatConfig() {
        return this.columnFamilyOptions.tableFormatConfig();
    }

    @Override
    public Options setTableFormatConfig(TableFormatConfig config) {
        this.columnFamilyOptions.setTableFormatConfig(config);
        return this;
    }

    @Override
    public String tableFactoryName() {
        return this.columnFamilyOptions.tableFactoryName();
    }

    @Override
    public Options useFixedLengthPrefixExtractor(int n) {
        this.columnFamilyOptions.useFixedLengthPrefixExtractor(n);
        return this;
    }

    @Override
    public Options useCappedPrefixExtractor(int n) {
        this.columnFamilyOptions.useCappedPrefixExtractor(n);
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return this.columnFamilyOptions.compressionType();
    }

    @Override
    public Options setCompressionPerLevel(List<CompressionType> compressionLevels) {
        this.columnFamilyOptions.setCompressionPerLevel((List)compressionLevels);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        return this.columnFamilyOptions.compressionPerLevel();
    }

    @Override
    public Options setCompressionType(CompressionType compressionType) {
        this.columnFamilyOptions.setCompressionType(compressionType);
        return this;
    }

    @Override
    public Options setBottommostCompressionType(CompressionType bottommostCompressionType) {
        this.columnFamilyOptions.setBottommostCompressionType(bottommostCompressionType);
        return this;
    }

    @Override
    public CompressionType bottommostCompressionType() {
        return this.columnFamilyOptions.bottommostCompressionType();
    }

    @Override
    public Options setCompressionOptions(CompressionOptions compressionOptions) {
        this.columnFamilyOptions.setCompressionOptions(compressionOptions);
        return this;
    }

    @Override
    public CompressionOptions compressionOptions() {
        return this.columnFamilyOptions.compressionOptions();
    }

    @Override
    public CompactionStyle compactionStyle() {
        return this.columnFamilyOptions.compactionStyle();
    }

    @Override
    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.columnFamilyOptions.setCompactionStyle(compactionStyle);
        return this;
    }

    @Override
    public int numLevels() {
        return this.columnFamilyOptions.numLevels();
    }

    @Override
    public Options setNumLevels(int numLevels) {
        this.columnFamilyOptions.setNumLevels(numLevels);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.columnFamilyOptions.levelZeroFileNumCompactionTrigger();
    }

    @Override
    public Options setLevelZeroFileNumCompactionTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroFileNumCompactionTrigger(numFiles);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.columnFamilyOptions.levelZeroSlowdownWritesTrigger();
    }

    @Override
    public Options setLevelZeroSlowdownWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroSlowdownWritesTrigger(numFiles);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.columnFamilyOptions.levelZeroStopWritesTrigger();
    }

    @Override
    public Options setLevelZeroStopWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroStopWritesTrigger(numFiles);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.columnFamilyOptions.targetFileSizeBase();
    }

    @Override
    public Options setTargetFileSizeBase(long targetFileSizeBase) {
        this.columnFamilyOptions.setTargetFileSizeBase(targetFileSizeBase);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.columnFamilyOptions.targetFileSizeMultiplier();
    }

    @Override
    public Options setTargetFileSizeMultiplier(int multiplier) {
        this.columnFamilyOptions.setTargetFileSizeMultiplier(multiplier);
        return this;
    }

    @Override
    public Options setMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.columnFamilyOptions.setMaxBytesForLevelBase(maxBytesForLevelBase);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.columnFamilyOptions.maxBytesForLevelBase();
    }

    @Override
    public Options setLevelCompactionDynamicLevelBytes(boolean enableLevelCompactionDynamicLevelBytes) {
        this.columnFamilyOptions.setLevelCompactionDynamicLevelBytes(enableLevelCompactionDynamicLevelBytes);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.columnFamilyOptions.levelCompactionDynamicLevelBytes();
    }

    @Override
    public double maxBytesForLevelMultiplier() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplier();
    }

    @Override
    public Options setMaxBytesForLevelMultiplier(double multiplier) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplier(multiplier);
        return this;
    }

    @Override
    public long maxCompactionBytes() {
        return this.columnFamilyOptions.maxCompactionBytes();
    }

    @Override
    public Options setMaxCompactionBytes(long maxCompactionBytes) {
        this.columnFamilyOptions.setMaxCompactionBytes(maxCompactionBytes);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.columnFamilyOptions.arenaBlockSize();
    }

    @Override
    public Options setArenaBlockSize(long arenaBlockSize) {
        this.columnFamilyOptions.setArenaBlockSize(arenaBlockSize);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.columnFamilyOptions.disableAutoCompactions();
    }

    @Override
    public Options setDisableAutoCompactions(boolean disableAutoCompactions) {
        this.columnFamilyOptions.setDisableAutoCompactions(disableAutoCompactions);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.columnFamilyOptions.maxSequentialSkipInIterations();
    }

    @Override
    public Options setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
        this.columnFamilyOptions.setMaxSequentialSkipInIterations(maxSequentialSkipInIterations);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.columnFamilyOptions.inplaceUpdateSupport();
    }

    @Override
    public Options setInplaceUpdateSupport(boolean inplaceUpdateSupport) {
        this.columnFamilyOptions.setInplaceUpdateSupport(inplaceUpdateSupport);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.columnFamilyOptions.inplaceUpdateNumLocks();
    }

    @Override
    public Options setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
        this.columnFamilyOptions.setInplaceUpdateNumLocks(inplaceUpdateNumLocks);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.columnFamilyOptions.memtablePrefixBloomSizeRatio();
    }

    @Override
    public Options setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
        this.columnFamilyOptions.setMemtablePrefixBloomSizeRatio(memtablePrefixBloomSizeRatio);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.columnFamilyOptions.bloomLocality();
    }

    @Override
    public Options setBloomLocality(int bloomLocality) {
        this.columnFamilyOptions.setBloomLocality(bloomLocality);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.columnFamilyOptions.maxSuccessiveMerges();
    }

    @Override
    public Options setMaxSuccessiveMerges(long maxSuccessiveMerges) {
        this.columnFamilyOptions.setMaxSuccessiveMerges(maxSuccessiveMerges);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.columnFamilyOptions.minWriteBufferNumberToMerge();
    }

    @Override
    public Options setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.columnFamilyOptions.setMinWriteBufferNumberToMerge(minWriteBufferNumberToMerge);
        return this;
    }

    @Override
    public Options setOptimizeFiltersForHits(boolean optimizeFiltersForHits) {
        this.columnFamilyOptions.setOptimizeFiltersForHits(optimizeFiltersForHits);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.columnFamilyOptions.optimizeFiltersForHits();
    }

    @Override
    public Options setMemtableHugePageSize(long memtableHugePageSize) {
        this.columnFamilyOptions.setMemtableHugePageSize(memtableHugePageSize);
        return this;
    }

    @Override
    public long memtableHugePageSize() {
        return this.columnFamilyOptions.memtableHugePageSize();
    }

    @Override
    public Options setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setSoftPendingCompactionBytesLimit(softPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long softPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.softPendingCompactionBytesLimit();
    }

    @Override
    public Options setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setHardPendingCompactionBytesLimit(hardPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long hardPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.hardPendingCompactionBytesLimit();
    }

    @Override
    public Options setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.columnFamilyOptions.setLevel0FileNumCompactionTrigger(level0FileNumCompactionTrigger);
        return this;
    }

    @Override
    public int level0FileNumCompactionTrigger() {
        return this.columnFamilyOptions.level0FileNumCompactionTrigger();
    }

    @Override
    public Options setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
        this.columnFamilyOptions.setLevel0SlowdownWritesTrigger(level0SlowdownWritesTrigger);
        return this;
    }

    @Override
    public int level0SlowdownWritesTrigger() {
        return this.columnFamilyOptions.level0SlowdownWritesTrigger();
    }

    @Override
    public Options setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
        this.columnFamilyOptions.setLevel0StopWritesTrigger(level0StopWritesTrigger);
        return this;
    }

    @Override
    public int level0StopWritesTrigger() {
        return this.columnFamilyOptions.level0StopWritesTrigger();
    }

    @Override
    public Options setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplierAdditional(maxBytesForLevelMultiplierAdditional);
        return this;
    }

    @Override
    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplierAdditional();
    }

    @Override
    public Options setParanoidFileChecks(boolean paranoidFileChecks) {
        this.columnFamilyOptions.setParanoidFileChecks(paranoidFileChecks);
        return this;
    }

    @Override
    public boolean paranoidFileChecks() {
        return this.columnFamilyOptions.paranoidFileChecks();
    }

    @Override
    public Options setMaxWriteBufferNumberToMaintain(int maxWriteBufferNumberToMaintain) {
        this.columnFamilyOptions.setMaxWriteBufferNumberToMaintain(maxWriteBufferNumberToMaintain);
        return this;
    }

    @Override
    public int maxWriteBufferNumberToMaintain() {
        return this.columnFamilyOptions.maxWriteBufferNumberToMaintain();
    }

    @Override
    public Options setCompactionPriority(CompactionPriority compactionPriority) {
        this.columnFamilyOptions.setCompactionPriority(compactionPriority);
        return this;
    }

    @Override
    public CompactionPriority compactionPriority() {
        return this.columnFamilyOptions.compactionPriority();
    }

    @Override
    public Options setReportBgIoStats(boolean reportBgIoStats) {
        this.columnFamilyOptions.setReportBgIoStats(reportBgIoStats);
        return this;
    }

    @Override
    public boolean reportBgIoStats() {
        return this.columnFamilyOptions.reportBgIoStats();
    }

    @Override
    public Options setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.columnFamilyOptions.setCompactionOptionsUniversal(compactionOptionsUniversal);
        return this;
    }

    @Override
    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.columnFamilyOptions.compactionOptionsUniversal();
    }

    @Override
    public Options setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.columnFamilyOptions.setCompactionOptionsFIFO(compactionOptionsFIFO);
        return this;
    }

    @Override
    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.columnFamilyOptions.compactionOptionsFIFO();
    }

    @Override
    public Options setForceConsistencyChecks(boolean forceConsistencyChecks) {
        this.columnFamilyOptions.setForceConsistencyChecks(forceConsistencyChecks);
        return this;
    }

    @Override
    public boolean forceConsistencyChecks() {
        return this.columnFamilyOptions.forceConsistencyChecks();
    }

    @Override
    public Options setWriteBufferManager(WriteBufferManager writeBufferManager) {
        this.dbOptions.setWriteBufferManager(writeBufferManager);
        return this;
    }

    @Override
    public WriteBufferManager writeBufferManager() {
        return this.dbOptions.writeBufferManager();
    }

    @Override
    public Options setMaxWriteBatchGroupSizeBytes(long maxWriteBatchGroupSizeBytes) {
        this.dbOptions.setMaxWriteBatchGroupSizeBytes(maxWriteBatchGroupSizeBytes);
        return this;
    }

    @Override
    public long maxWriteBatchGroupSizeBytes() {
        return this.dbOptions.maxWriteBatchGroupSizeBytes();
    }

    @Override
    public Options oldDefaults(int majorVersion, int minorVersion) {
        this.columnFamilyOptions.oldDefaults(majorVersion, minorVersion);
        return this;
    }

    @Override
    public Options optimizeForSmallDb(Cache cache) {
        return super.optimizeForSmallDb(cache);
    }

    @Override
    public AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter() {
        return this.columnFamilyOptions.compactionFilter();
    }

    @Override
    public AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory() {
        return this.columnFamilyOptions.compactionFilterFactory();
    }

    @Override
    public Options setStatsPersistPeriodSec(int statsPersistPeriodSec) {
        this.dbOptions.setStatsPersistPeriodSec(statsPersistPeriodSec);
        return this;
    }

    @Override
    public int statsPersistPeriodSec() {
        return this.dbOptions.statsPersistPeriodSec();
    }

    @Override
    public Options setStatsHistoryBufferSize(long statsHistoryBufferSize) {
        this.dbOptions.setStatsHistoryBufferSize(statsHistoryBufferSize);
        return this;
    }

    @Override
    public long statsHistoryBufferSize() {
        return this.dbOptions.statsHistoryBufferSize();
    }

    @Override
    public Options setStrictBytesPerSync(boolean strictBytesPerSync) {
        this.dbOptions.setStrictBytesPerSync(strictBytesPerSync);
        return this;
    }

    @Override
    public boolean strictBytesPerSync() {
        return this.dbOptions.strictBytesPerSync();
    }

    @Override
    public Options setListeners(List<AbstractEventListener> listeners) {
        this.dbOptions.setListeners((List)listeners);
        return this;
    }

    @Override
    public List<AbstractEventListener> listeners() {
        return this.dbOptions.listeners();
    }

    @Override
    public Options setEnablePipelinedWrite(boolean enablePipelinedWrite) {
        this.dbOptions.setEnablePipelinedWrite(enablePipelinedWrite);
        return this;
    }

    @Override
    public boolean enablePipelinedWrite() {
        return this.dbOptions.enablePipelinedWrite();
    }

    @Override
    public Options setUnorderedWrite(boolean unorderedWrite) {
        this.dbOptions.setUnorderedWrite(unorderedWrite);
        return this;
    }

    @Override
    public boolean unorderedWrite() {
        return this.dbOptions.unorderedWrite();
    }

    @Override
    public Options setSkipCheckingSstFileSizesOnDbOpen(boolean skipCheckingSstFileSizesOnDbOpen) {
        this.dbOptions.setSkipCheckingSstFileSizesOnDbOpen(skipCheckingSstFileSizesOnDbOpen);
        return this;
    }

    @Override
    public boolean skipCheckingSstFileSizesOnDbOpen() {
        return this.dbOptions.skipCheckingSstFileSizesOnDbOpen();
    }

    @Override
    public Options setWalFilter(AbstractWalFilter walFilter) {
        this.logIgnoreWalOption("walFilter");
        return this;
    }

    @Override
    public WalFilter walFilter() {
        return this.dbOptions.walFilter();
    }

    @Override
    public Options setAllowIngestBehind(boolean allowIngestBehind) {
        this.dbOptions.setAllowIngestBehind(allowIngestBehind);
        return this;
    }

    @Override
    public boolean allowIngestBehind() {
        return this.dbOptions.allowIngestBehind();
    }

    @Deprecated
    public Options setPreserveDeletes(boolean preserveDeletes) {
        String message = "This method has been removed from the underlying RocksDB. It was marked for deprecation in earlier versions. The behaviour can be replicated by using user-defined timestamps. It is currently a no-op method.";
        log.warn("This method has been removed from the underlying RocksDB. It was marked for deprecation in earlier versions. The behaviour can be replicated by using user-defined timestamps. It is currently a no-op method.");
        return this;
    }

    @Deprecated
    public boolean preserveDeletes() {
        String message = "This method has been removed from the underlying RocksDB. It was marked for deprecation in earlier versions. It is currently a no-op method with a default value of false.";
        log.warn("This method has been removed from the underlying RocksDB. It was marked for deprecation in earlier versions. It is currently a no-op method with a default value of false.");
        return false;
    }

    @Override
    public Options setTwoWriteQueues(boolean twoWriteQueues) {
        this.dbOptions.setTwoWriteQueues(twoWriteQueues);
        return this;
    }

    @Override
    public boolean twoWriteQueues() {
        return this.dbOptions.twoWriteQueues();
    }

    @Override
    public Options setManualWalFlush(boolean manualWalFlush) {
        this.logIgnoreWalOption("manualWalFlush");
        return this;
    }

    @Override
    public boolean manualWalFlush() {
        return this.dbOptions.manualWalFlush();
    }

    @Override
    public Options setCfPaths(Collection<DbPath> cfPaths) {
        this.columnFamilyOptions.setCfPaths((Collection)cfPaths);
        return this;
    }

    @Override
    public List<DbPath> cfPaths() {
        return this.columnFamilyOptions.cfPaths();
    }

    @Override
    public Options setBottommostCompressionOptions(CompressionOptions bottommostCompressionOptions) {
        this.columnFamilyOptions.setBottommostCompressionOptions(bottommostCompressionOptions);
        return this;
    }

    @Override
    public CompressionOptions bottommostCompressionOptions() {
        return this.columnFamilyOptions.bottommostCompressionOptions();
    }

    @Override
    public Options setTtl(long ttl) {
        this.columnFamilyOptions.setTtl(ttl);
        return this;
    }

    @Override
    public long ttl() {
        return this.columnFamilyOptions.ttl();
    }

    @Override
    public Options setPeriodicCompactionSeconds(long periodicCompactionSeconds) {
        this.columnFamilyOptions.setPeriodicCompactionSeconds(periodicCompactionSeconds);
        return this;
    }

    @Override
    public long periodicCompactionSeconds() {
        return this.columnFamilyOptions.periodicCompactionSeconds();
    }

    @Override
    public Options setAtomicFlush(boolean atomicFlush) {
        this.dbOptions.setAtomicFlush(atomicFlush);
        return this;
    }

    @Override
    public boolean atomicFlush() {
        return this.dbOptions.atomicFlush();
    }

    @Override
    public Options setAvoidUnnecessaryBlockingIO(boolean avoidUnnecessaryBlockingIO) {
        this.dbOptions.setAvoidUnnecessaryBlockingIO(avoidUnnecessaryBlockingIO);
        return this;
    }

    @Override
    public boolean avoidUnnecessaryBlockingIO() {
        return this.dbOptions.avoidUnnecessaryBlockingIO();
    }

    @Override
    public Options setPersistStatsToDisk(boolean persistStatsToDisk) {
        this.dbOptions.setPersistStatsToDisk(persistStatsToDisk);
        return this;
    }

    @Override
    public boolean persistStatsToDisk() {
        return this.dbOptions.persistStatsToDisk();
    }

    @Override
    public Options setWriteDbidToManifest(boolean writeDbidToManifest) {
        this.dbOptions.setWriteDbidToManifest(writeDbidToManifest);
        return this;
    }

    @Override
    public boolean writeDbidToManifest() {
        return this.dbOptions.writeDbidToManifest();
    }

    @Override
    public Options setLogReadaheadSize(long logReadaheadSize) {
        this.dbOptions.setLogReadaheadSize(logReadaheadSize);
        return this;
    }

    @Override
    public long logReadaheadSize() {
        return this.dbOptions.logReadaheadSize();
    }

    @Override
    public Options setBestEffortsRecovery(boolean bestEffortsRecovery) {
        this.dbOptions.setBestEffortsRecovery(bestEffortsRecovery);
        return this;
    }

    @Override
    public boolean bestEffortsRecovery() {
        return this.dbOptions.bestEffortsRecovery();
    }

    @Override
    public Options setMaxBgErrorResumeCount(int maxBgerrorResumeCount) {
        this.dbOptions.setMaxBgErrorResumeCount(maxBgerrorResumeCount);
        return this;
    }

    @Override
    public int maxBgerrorResumeCount() {
        return this.dbOptions.maxBgerrorResumeCount();
    }

    @Override
    public Options setBgerrorResumeRetryInterval(long bgerrorResumeRetryInterval) {
        this.dbOptions.setBgerrorResumeRetryInterval(bgerrorResumeRetryInterval);
        return this;
    }

    @Override
    public long bgerrorResumeRetryInterval() {
        return this.dbOptions.bgerrorResumeRetryInterval();
    }

    @Override
    public Options setSstPartitionerFactory(SstPartitionerFactory sstPartitionerFactory) {
        this.columnFamilyOptions.setSstPartitionerFactory(sstPartitionerFactory);
        return this;
    }

    @Override
    public SstPartitionerFactory sstPartitionerFactory() {
        return this.columnFamilyOptions.sstPartitionerFactory();
    }

    @Override
    public Options setCompactionThreadLimiter(ConcurrentTaskLimiter compactionThreadLimiter) {
        this.columnFamilyOptions.setCompactionThreadLimiter(compactionThreadLimiter);
        return this;
    }

    @Override
    public ConcurrentTaskLimiter compactionThreadLimiter() {
        return this.columnFamilyOptions.compactionThreadLimiter();
    }

    @Override
    public Options setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter) {
        this.columnFamilyOptions.setCompactionFilter((AbstractCompactionFilter)compactionFilter);
        return this;
    }

    @Override
    public Options setCompactionFilterFactory(AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory) {
        this.columnFamilyOptions.setCompactionFilterFactory((AbstractCompactionFilterFactory)compactionFilterFactory);
        return this;
    }

    @Override
    public Options setBlobCompactionReadaheadSize(long blobCompactionReadaheadSize) {
        this.columnFamilyOptions.setBlobCompactionReadaheadSize(blobCompactionReadaheadSize);
        return this;
    }

    @Override
    public long blobCompactionReadaheadSize() {
        return this.columnFamilyOptions.blobCompactionReadaheadSize();
    }

    @Override
    public Options setMemtableWholeKeyFiltering(boolean memtableWholeKeyFiltering) {
        this.columnFamilyOptions.setMemtableWholeKeyFiltering(memtableWholeKeyFiltering);
        return this;
    }

    @Override
    public boolean memtableWholeKeyFiltering() {
        return this.columnFamilyOptions.memtableWholeKeyFiltering();
    }

    @Override
    public Options setExperimentalMempurgeThreshold(double experimentalMempurgeThreshold) {
        this.columnFamilyOptions.setExperimentalMempurgeThreshold(experimentalMempurgeThreshold);
        return this;
    }

    @Override
    public double experimentalMempurgeThreshold() {
        return this.columnFamilyOptions.experimentalMempurgeThreshold();
    }

    @Override
    public Options setEnableBlobFiles(boolean enableBlobFiles) {
        this.columnFamilyOptions.setEnableBlobFiles(enableBlobFiles);
        return this;
    }

    @Override
    public boolean enableBlobFiles() {
        return this.columnFamilyOptions.enableBlobFiles();
    }

    @Override
    public Options setMinBlobSize(long minBlobSize) {
        this.columnFamilyOptions.setMinBlobSize(minBlobSize);
        return this;
    }

    @Override
    public long minBlobSize() {
        return this.columnFamilyOptions.minBlobSize();
    }

    @Override
    public Options setBlobFileSize(long blobFileSize) {
        this.columnFamilyOptions.setBlobFileSize(blobFileSize);
        return this;
    }

    @Override
    public long blobFileSize() {
        return this.columnFamilyOptions.blobFileSize();
    }

    @Override
    public Options setBlobCompressionType(CompressionType compressionType) {
        this.columnFamilyOptions.setBlobCompressionType(compressionType);
        return this;
    }

    @Override
    public CompressionType blobCompressionType() {
        return this.columnFamilyOptions.blobCompressionType();
    }

    @Override
    public Options setEnableBlobGarbageCollection(boolean enableBlobGarbageCollection) {
        this.columnFamilyOptions.setEnableBlobGarbageCollection(enableBlobGarbageCollection);
        return this;
    }

    @Override
    public boolean enableBlobGarbageCollection() {
        return this.columnFamilyOptions.enableBlobGarbageCollection();
    }

    @Override
    public Options setBlobGarbageCollectionAgeCutoff(double blobGarbageCollectionAgeCutoff) {
        this.columnFamilyOptions.setBlobGarbageCollectionAgeCutoff(blobGarbageCollectionAgeCutoff);
        return this;
    }

    @Override
    public double blobGarbageCollectionAgeCutoff() {
        return this.columnFamilyOptions.blobGarbageCollectionAgeCutoff();
    }

    @Override
    public Options setBlobGarbageCollectionForceThreshold(double blobGarbageCollectionForceThreshold) {
        this.columnFamilyOptions.setBlobGarbageCollectionForceThreshold(blobGarbageCollectionForceThreshold);
        return this;
    }

    @Override
    public double blobGarbageCollectionForceThreshold() {
        return this.columnFamilyOptions.blobGarbageCollectionForceThreshold();
    }

    @Override
    public Options setPrepopulateBlobCache(PrepopulateBlobCache prepopulateBlobCache) {
        this.columnFamilyOptions.setPrepopulateBlobCache(prepopulateBlobCache);
        return this;
    }

    @Override
    public PrepopulateBlobCache prepopulateBlobCache() {
        return this.columnFamilyOptions.prepopulateBlobCache();
    }

    @Override
    public Options setBlobFileStartingLevel(int blobFileStartingLevel) {
        this.columnFamilyOptions.setBlobFileStartingLevel(blobFileStartingLevel);
        return this;
    }

    @Override
    public int blobFileStartingLevel() {
        return this.columnFamilyOptions.blobFileStartingLevel();
    }

    @Override
    public void close() {
        this.dbOptions.close();
        this.columnFamilyOptions.close();
        super.close();
    }

    private void logIgnoreWalOption(String option) {
        log.warn("WAL is explicitly disabled by Streams in RocksDB. Setting option '{}' will be ignored", (Object)option);
    }
}

