/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class PrefixedWindowKeySchemas {
    private static final int PREFIX_SIZE = 1;
    private static final byte TIME_FIRST_PREFIX = 0;
    private static final byte KEY_FIRST_PREFIX = 1;
    private static final int SEQNUM_SIZE = 4;

    private static byte extractPrefix(byte[] binaryBytes) {
        return binaryBytes[0];
    }

    public static boolean isTimeFirstSchemaKey(byte[] binaryBytes) {
        return binaryBytes.length > 0 && binaryBytes[0] == 0;
    }

    public static class KeyFirstWindowKeySchema
    implements SegmentedBytesStore.KeySchema {
        @Override
        public Bytes upperRange(Bytes key, long to) {
            Bytes noPrefixBytes = new WindowKeySchema().upperRange(key, to);
            return KeyFirstWindowKeySchema.wrapPrefix(noPrefixBytes, true);
        }

        @Override
        public Bytes lowerRange(Bytes key, long from) {
            Bytes noPrefixBytes = new WindowKeySchema().lowerRange(key, from);
            return KeyFirstWindowKeySchema.wrapPrefix(noPrefixBytes, false);
        }

        @Override
        public Bytes lowerRangeFixedSize(Bytes key, long from) {
            Bytes noPrefixBytes = WindowKeySchema.toStoreKeyBinary(key, Math.max(0L, from), 0);
            return KeyFirstWindowKeySchema.wrapPrefix(noPrefixBytes, false);
        }

        @Override
        public Bytes upperRangeFixedSize(Bytes key, long to) {
            Bytes noPrefixBytes = WindowKeySchema.toStoreKeyBinary(key, to, Integer.MAX_VALUE);
            return KeyFirstWindowKeySchema.wrapPrefix(noPrefixBytes, true);
        }

        @Override
        public long segmentTimestamp(Bytes key) {
            return KeyFirstWindowKeySchema.extractStoreTimestamp(key.get());
        }

        @Override
        public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to, boolean forward) {
            return iterator -> {
                while (iterator.hasNext()) {
                    Bytes bytes = (Bytes)iterator.peekNextKey();
                    byte prefix = PrefixedWindowKeySchemas.extractPrefix(bytes.get());
                    if (prefix != 1) {
                        return false;
                    }
                    Bytes keyBytes = Bytes.wrap(KeyFirstWindowKeySchema.extractStoreKeyBytes(bytes.get()));
                    long time = KeyFirstWindowKeySchema.extractStoreTimestamp(bytes.get());
                    if (!(binaryKeyFrom != null && keyBytes.compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && keyBytes.compareTo(binaryKeyTo) > 0 || time < from || time > to)) {
                        return true;
                    }
                    iterator.next();
                }
                return false;
            };
        }

        @Override
        public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to, boolean forward) {
            return segments.segments(from, to, forward);
        }

        public static <K> Bytes toStoreKeyBinary(K key, long timestamp, int seqnum, StateSerdes<K, ?> serdes) {
            byte[] serializedKey = serdes.rawKey(key);
            return KeyFirstWindowKeySchema.toStoreKeyBinary(serializedKey, timestamp, seqnum);
        }

        public static Bytes toStoreKeyBinary(Windowed<Bytes> timeKey, int seqnum) {
            return KeyFirstWindowKeySchema.toStoreKeyBinary(timeKey.key().get(), timeKey.window().start(), seqnum);
        }

        public static <K> Bytes toStoreKeyBinary(Windowed<K> timeKey, int seqnum, StateSerdes<K, ?> serdes) {
            byte[] serializedKey = serdes.rawKey(timeKey.key());
            return KeyFirstWindowKeySchema.toStoreKeyBinary(serializedKey, timeKey.window().start(), seqnum);
        }

        public static Bytes toStoreKeyBinary(Bytes key, long timestamp, int seqnum) {
            return KeyFirstWindowKeySchema.toStoreKeyBinary(key.get(), timestamp, seqnum);
        }

        public static Bytes toStoreKeyBinary(byte[] serializedKey, long timestamp, int seqnum) {
            ByteBuffer buf = ByteBuffer.allocate(1 + serializedKey.length + 8 + 4);
            buf.put((byte)1);
            buf.put(serializedKey);
            buf.putLong(timestamp);
            buf.putInt(seqnum);
            return Bytes.wrap(buf.array());
        }

        static byte[] extractStoreKeyBytes(byte[] binaryKey) {
            byte[] bytes = new byte[binaryKey.length - 8 - 4 - 1];
            System.arraycopy(binaryKey, 1, bytes, 0, bytes.length);
            return bytes;
        }

        public static Windowed<Bytes> fromStoreBytesKey(byte[] binaryKey, long windowSize) {
            Bytes key = Bytes.wrap(KeyFirstWindowKeySchema.extractStoreKeyBytes(binaryKey));
            Window window = KeyFirstWindowKeySchema.extractStoreWindow(binaryKey, windowSize);
            return new Windowed<Bytes>(key, window);
        }

        static long extractStoreTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8 - 4);
        }

        static int extractStoreSequence(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getInt(binaryKey.length - 4);
        }

        static Window extractStoreWindow(byte[] binaryKey, long windowSize) {
            long start = KeyFirstWindowKeySchema.extractStoreTimestamp(binaryKey);
            return WindowKeySchema.timeWindowForSize(start, windowSize);
        }

        public static <K> Windowed<K> fromStoreKey(byte[] binaryKey, long windowSize, Deserializer<K> deserializer, String topic) {
            K key = deserializer.deserialize(topic, KeyFirstWindowKeySchema.extractStoreKeyBytes(binaryKey));
            Window window = KeyFirstWindowKeySchema.extractStoreWindow(binaryKey, windowSize);
            return new Windowed<K>(key, window);
        }

        private static Bytes wrapPrefix(Bytes noPrefixKey, boolean upperRange) {
            if (noPrefixKey == null) {
                byte prefix = upperRange ? (byte)2 : 1;
                byte[] ret = ByteBuffer.allocate(1).put(prefix).array();
                return Bytes.wrap(ret);
            }
            byte[] ret = ByteBuffer.allocate(1 + noPrefixKey.get().length).put((byte)1).put(noPrefixKey.get()).array();
            return Bytes.wrap(ret);
        }

        public static byte[] fromNonPrefixWindowKey(byte[] binaryKey) {
            return KeyFirstWindowKeySchema.wrapPrefix(Bytes.wrap(binaryKey), false).get();
        }
    }

    public static class TimeFirstWindowKeySchema
    implements SegmentedBytesStore.KeySchema {
        @Override
        public Bytes upperRange(Bytes key, long to) {
            if (key == null) {
                boolean nextPrefix = true;
                return Bytes.wrap(ByteBuffer.allocate(1).put((byte)1).array());
            }
            byte[] maxKey = new byte[key.get().length];
            Arrays.fill(maxKey, (byte)-1);
            return Bytes.wrap(ByteBuffer.allocate(9 + maxKey.length + 4).put((byte)0).putLong(to).put(maxKey).putInt(Integer.MAX_VALUE).array());
        }

        @Override
        public Bytes lowerRange(Bytes key, long from) {
            if (key == null) {
                return Bytes.wrap(ByteBuffer.allocate(9).put((byte)0).putLong(from).array());
            }
            return Bytes.wrap(ByteBuffer.allocate(9 + key.get().length).put((byte)0).putLong(from).put(key.get()).array());
        }

        @Override
        public Bytes lowerRangeFixedSize(Bytes key, long from) {
            return TimeFirstWindowKeySchema.toStoreKeyBinary(key, Math.max(0L, from), 0);
        }

        @Override
        public Bytes upperRangeFixedSize(Bytes key, long to) {
            return TimeFirstWindowKeySchema.toStoreKeyBinary(key, to, Integer.MAX_VALUE);
        }

        @Override
        public long segmentTimestamp(Bytes key) {
            return TimeFirstWindowKeySchema.extractStoreTimestamp(key.get());
        }

        @Override
        public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to, boolean forward) {
            return iterator -> {
                while (iterator.hasNext()) {
                    Bytes bytes = (Bytes)iterator.peekNextKey();
                    byte prefix = PrefixedWindowKeySchemas.extractPrefix(bytes.get());
                    if (prefix != 0) {
                        return false;
                    }
                    long time = TimeFirstWindowKeySchema.extractStoreTimestamp(bytes.get());
                    if (forward && time > to) {
                        return false;
                    }
                    if (!forward && time < from) {
                        return false;
                    }
                    Bytes keyBytes = Bytes.wrap(TimeFirstWindowKeySchema.extractStoreKeyBytes(bytes.get()));
                    if (!(binaryKeyFrom != null && keyBytes.compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && keyBytes.compareTo(binaryKeyTo) > 0 || time < from || time > to)) {
                        return true;
                    }
                    iterator.next();
                }
                return false;
            };
        }

        @Override
        public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to, boolean forward) {
            return segments.segments(from, to, forward);
        }

        static byte[] extractStoreKeyBytes(byte[] binaryKey) {
            byte[] bytes = new byte[binaryKey.length - 8 - 4 - 1];
            System.arraycopy(binaryKey, 9, bytes, 0, bytes.length);
            return bytes;
        }

        static long extractStoreTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(1);
        }

        public static Bytes toStoreKeyBinary(Windowed<Bytes> timeKey, int seqnum) {
            return TimeFirstWindowKeySchema.toStoreKeyBinary(timeKey.key().get(), timeKey.window().start(), seqnum);
        }

        public static <K> Windowed<K> fromStoreKey(byte[] binaryKey, long windowSize, Deserializer<K> deserializer, String topic) {
            K key = deserializer.deserialize(topic, TimeFirstWindowKeySchema.extractStoreKeyBytes(binaryKey));
            Window window = TimeFirstWindowKeySchema.extractStoreWindow(binaryKey, windowSize);
            return new Windowed<K>(key, window);
        }

        public static <K> Bytes toStoreKeyBinary(Windowed<K> timeKey, int seqnum, StateSerdes<K, ?> serdes) {
            byte[] serializedKey = serdes.rawKey(timeKey.key());
            return TimeFirstWindowKeySchema.toStoreKeyBinary(serializedKey, timeKey.window().start(), seqnum);
        }

        public static <K> Bytes toStoreKeyBinary(K key, long timestamp, int seqnum, StateSerdes<K, ?> serdes) {
            byte[] serializedKey = serdes.rawKey(key);
            return TimeFirstWindowKeySchema.toStoreKeyBinary(serializedKey, timestamp, seqnum);
        }

        public static Bytes toStoreKeyBinary(Bytes key, long timestamp, int seqnum) {
            return TimeFirstWindowKeySchema.toStoreKeyBinary(key.get(), timestamp, seqnum);
        }

        static Bytes toStoreKeyBinary(byte[] serializedKey, long timestamp, int seqnum) {
            ByteBuffer buf = ByteBuffer.allocate(9 + serializedKey.length + 4);
            buf.put((byte)0);
            buf.putLong(timestamp);
            buf.put(serializedKey);
            buf.putInt(seqnum);
            return Bytes.wrap(buf.array());
        }

        public static Windowed<Bytes> fromStoreBytesKey(byte[] binaryKey, long windowSize) {
            Bytes key = Bytes.wrap(TimeFirstWindowKeySchema.extractStoreKeyBytes(binaryKey));
            Window window = TimeFirstWindowKeySchema.extractStoreWindow(binaryKey, windowSize);
            return new Windowed<Bytes>(key, window);
        }

        static Window extractStoreWindow(byte[] binaryKey, long windowSize) {
            long start = TimeFirstWindowKeySchema.extractStoreTimestamp(binaryKey);
            return WindowKeySchema.timeWindowForSize(start, windowSize);
        }

        static int extractStoreSequence(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getInt(binaryKey.length - 4);
        }

        public static byte[] fromNonPrefixWindowKey(byte[] binaryKey) {
            ByteBuffer buffer = ByteBuffer.allocate(1 + binaryKey.length).put((byte)0);
            buffer.put(binaryKey, binaryKey.length - 4 - 8, 8);
            buffer.put(binaryKey, 0, binaryKey.length - 4 - 8);
            buffer.put(binaryKey, binaryKey.length - 4, 4);
            return buffer.array();
        }
    }
}

