/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.RecordContext;
import org.apache.kafka.streams.processor.api.RecordMetadata;

public class ProcessorRecordContext
implements RecordContext,
RecordMetadata {
    private final long timestamp;
    private final long offset;
    private final String topic;
    private final int partition;
    private final Headers headers;

    public ProcessorRecordContext(long timestamp, long offset, int partition, String topic, Headers headers) {
        this.timestamp = timestamp;
        this.offset = offset;
        this.topic = topic;
        this.partition = partition;
        this.headers = Objects.requireNonNull(headers);
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public long residentMemorySizeEstimate() {
        long size = 0L;
        size += 8L;
        size += 8L;
        if (this.topic != null) {
            size += (long)this.topic.toCharArray().length;
        }
        size += 4L;
        for (Header header : this.headers) {
            size += (long)header.key().toCharArray().length;
            byte[] value = header.value();
            if (value == null) continue;
            size += (long)value.length;
        }
        return size;
    }

    public byte[] serialize() {
        byte[] topicBytes = this.topic.getBytes(StandardCharsets.UTF_8);
        int size = 0;
        size += 8;
        size += 8;
        size += 4;
        size += topicBytes.length;
        size += 4;
        size += 4;
        Header[] headers = this.headers.toArray();
        byte[][] headerKeysBytes = new byte[headers.length][];
        byte[][] headerValuesBytes = new byte[headers.length][];
        for (int i = 0; i < headers.length; ++i) {
            size += 8;
            byte[] keyBytes = headers[i].key().getBytes(StandardCharsets.UTF_8);
            size += keyBytes.length;
            byte[] valueBytes = headers[i].value();
            if (valueBytes != null) {
                size += valueBytes.length;
            }
            headerKeysBytes[i] = keyBytes;
            headerValuesBytes[i] = valueBytes;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putLong(this.timestamp);
        buffer.putLong(this.offset);
        buffer.putInt(topicBytes.length);
        buffer.put(topicBytes);
        buffer.putInt(this.partition);
        buffer.putInt(headerKeysBytes.length);
        for (int i = 0; i < headerKeysBytes.length; ++i) {
            buffer.putInt(headerKeysBytes[i].length);
            buffer.put(headerKeysBytes[i]);
            if (headerValuesBytes[i] != null) {
                buffer.putInt(headerValuesBytes[i].length);
                buffer.put(headerValuesBytes[i]);
                continue;
            }
            buffer.putInt(-1);
        }
        return buffer.array();
    }

    public static ProcessorRecordContext deserialize(ByteBuffer buffer) {
        RecordHeaders headers;
        long timestamp = buffer.getLong();
        long offset = buffer.getLong();
        byte[] topicBytes = Objects.requireNonNull(Utils.getNullableSizePrefixedArray(buffer));
        String topic = new String(topicBytes, StandardCharsets.UTF_8);
        int partition = buffer.getInt();
        int headerCount = buffer.getInt();
        if (headerCount == -1) {
            headers = new RecordHeaders();
        } else {
            Header[] headerArr = new Header[headerCount];
            for (int i = 0; i < headerCount; ++i) {
                byte[] keyBytes = Objects.requireNonNull(Utils.getNullableSizePrefixedArray(buffer));
                byte[] valueBytes = Utils.getNullableSizePrefixedArray(buffer);
                headerArr[i] = new RecordHeader(new String(keyBytes, StandardCharsets.UTF_8), valueBytes);
            }
            headers = new RecordHeaders(headerArr);
        }
        return new ProcessorRecordContext(timestamp, offset, partition, topic, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorRecordContext that = (ProcessorRecordContext)o;
        return this.timestamp == that.timestamp && this.offset == that.offset && this.partition == that.partition && Objects.equals(this.topic, that.topic) && Objects.equals(this.headers, that.headers);
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("ProcessorRecordContext is unsafe for use in Hash collections due to the mutable Headers field");
    }

    public String toString() {
        return "ProcessorRecordContext{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", headers=" + this.headers + '}';
    }
}

