/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.slf4j.Logger;

public class ChangelogTopics {
    private final InternalTopicManager internalTopicManager;
    private final Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups;
    private final Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup;
    private final Map<TaskId, Set<TopicPartition>> changelogPartitionsForStatefulTask = new HashMap<TaskId, Set<TopicPartition>>();
    private final Map<TaskId, Set<TopicPartition>> preExistingChangelogPartitionsForTask = new HashMap<TaskId, Set<TopicPartition>>();
    private final Set<TopicPartition> preExistingNonSourceTopicBasedChangelogPartitions = new HashSet<TopicPartition>();
    private final Set<String> sourceTopicBasedChangelogTopics = new HashSet<String>();
    private final Set<TopicPartition> preExistingSourceTopicBasedChangelogPartitions = new HashSet<TopicPartition>();
    private final Logger log;

    public ChangelogTopics(InternalTopicManager internalTopicManager, Map<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> topicGroups, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup, String logPrefix) {
        this.internalTopicManager = internalTopicManager;
        this.topicGroups = topicGroups;
        this.tasksForTopicGroup = tasksForTopicGroup;
        LogContext logContext = new LogContext(logPrefix);
        this.log = logContext.logger(this.getClass());
    }

    public void setup() {
        HashMap<String, InternalTopicConfig> changelogTopicMetadata = new HashMap<String, InternalTopicConfig>();
        for (Map.Entry<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> entry : this.topicGroups.entrySet()) {
            TopologyMetadata.Subtopology subtopology = entry.getKey();
            InternalTopologyBuilder.TopicsInfo topicsInfo = entry.getValue();
            Set<TaskId> topicGroupTasks = this.tasksForTopicGroup.get(subtopology);
            if (topicGroupTasks == null) {
                this.log.debug("No tasks found for subtopology {}", (Object)subtopology);
                continue;
            }
            if (topicsInfo.stateChangelogTopics.isEmpty()) continue;
            for (TaskId task2 : topicGroupTasks) {
                Set changelogTopicPartitions = topicsInfo.stateChangelogTopics.keySet().stream().map(topic -> new TopicPartition((String)topic, task2.partition())).collect(Collectors.toSet());
                this.changelogPartitionsForStatefulTask.put(task2, changelogTopicPartitions);
            }
            for (InternalTopicConfig topicConfig : topicsInfo.nonSourceChangelogTopics()) {
                int numPartitions = -1;
                for (TaskId task3 : topicGroupTasks) {
                    if (numPartitions >= task3.partition() + 1) continue;
                    numPartitions = task3.partition() + 1;
                }
                topicConfig.setNumberOfPartitions(numPartitions);
                changelogTopicMetadata.put(topicConfig.name(), topicConfig);
            }
            this.sourceTopicBasedChangelogTopics.addAll(topicsInfo.sourceTopicChangelogs());
        }
        Set<String> newlyCreatedChangelogTopics = this.internalTopicManager.makeReady(changelogTopicMetadata);
        this.log.debug("Created state changelog topics {} from the parsed topology.", changelogTopicMetadata.values());
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.changelogPartitionsForStatefulTask.entrySet()) {
            TaskId taskId = entry.getKey();
            Set<TopicPartition> topicPartitions = entry.getValue();
            for (TopicPartition topicPartition : topicPartitions) {
                if (newlyCreatedChangelogTopics.contains(topicPartition.topic())) continue;
                this.preExistingChangelogPartitionsForTask.computeIfAbsent(taskId, task -> new HashSet()).add(topicPartition);
                if (!this.sourceTopicBasedChangelogTopics.contains(topicPartition.topic())) {
                    this.preExistingNonSourceTopicBasedChangelogPartitions.add(topicPartition);
                    continue;
                }
                this.preExistingSourceTopicBasedChangelogPartitions.add(topicPartition);
            }
        }
    }

    public Set<TopicPartition> preExistingNonSourceTopicBasedPartitions() {
        return Collections.unmodifiableSet(this.preExistingNonSourceTopicBasedChangelogPartitions);
    }

    public Set<TopicPartition> preExistingPartitionsFor(TaskId taskId) {
        if (this.preExistingChangelogPartitionsForTask.containsKey(taskId)) {
            return Collections.unmodifiableSet(this.preExistingChangelogPartitionsForTask.get(taskId));
        }
        return Collections.emptySet();
    }

    public Set<TopicPartition> preExistingSourceTopicBasedPartitions() {
        return Collections.unmodifiableSet(this.preExistingSourceTopicBasedChangelogPartitions);
    }

    public Set<TaskId> statefulTaskIds() {
        return Collections.unmodifiableSet(this.changelogPartitionsForStatefulTask.keySet());
    }

    public Map<TaskId, Set<TopicPartition>> changelogPartionsForTask() {
        return Collections.unmodifiableMap(this.changelogPartitionsForStatefulTask);
    }
}

