/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.api;

import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.streams.errors.StreamsException;

public final class FixedKeyRecord<K, V> {
    private final K key;
    private final V value;
    private final long timestamp;
    private final Headers headers;

    FixedKeyRecord(K key, V value, long timestamp, Headers headers) {
        this.key = key;
        this.value = value;
        if (timestamp < 0L) {
            throw new StreamsException("Malformed Record", new IllegalArgumentException("Timestamp may not be negative. Got: " + timestamp));
        }
        this.timestamp = timestamp;
        this.headers = new RecordHeaders(headers);
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Headers headers() {
        return this.headers;
    }

    public <NewV> FixedKeyRecord<K, NewV> withValue(NewV value) {
        return new FixedKeyRecord<K, NewV>(this.key, value, this.timestamp, this.headers);
    }

    public FixedKeyRecord<K, V> withTimestamp(long timestamp) {
        return new FixedKeyRecord<K, V>(this.key, this.value, timestamp, this.headers);
    }

    public FixedKeyRecord<K, V> withHeaders(Headers headers) {
        return new FixedKeyRecord<K, V>(this.key, this.value, this.timestamp, headers);
    }

    public String toString() {
        return "FixedKeyRecord{key=" + this.key + ", value=" + this.value + ", timestamp=" + this.timestamp + ", headers=" + this.headers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedKeyRecord record = (FixedKeyRecord)o;
        return this.timestamp == record.timestamp && Objects.equals(this.key, record.key) && Objects.equals(this.value, record.value) && Objects.equals(this.headers, record.headers);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.timestamp, this.headers);
    }
}

