/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.processor.api.ProcessorContext;

public class CombinedKeySchema<KO, K> {
    private final Supplier<String> undecoratedPrimaryKeySerdeTopicSupplier;
    private final Supplier<String> undecoratedForeignKeySerdeTopicSupplier;
    private String primaryKeySerdeTopic;
    private String foreignKeySerdeTopic;
    private Serializer<K> primaryKeySerializer;
    private Deserializer<K> primaryKeyDeserializer;
    private Serializer<KO> foreignKeySerializer;
    private Deserializer<KO> foreignKeyDeserializer;

    public CombinedKeySchema(Supplier<String> foreignKeySerdeTopicSupplier, Serde<KO> foreignKeySerde, Supplier<String> primaryKeySerdeTopicSupplier, Serde<K> primaryKeySerde) {
        this.undecoratedPrimaryKeySerdeTopicSupplier = primaryKeySerdeTopicSupplier;
        this.undecoratedForeignKeySerdeTopicSupplier = foreignKeySerdeTopicSupplier;
        this.primaryKeySerializer = primaryKeySerde == null ? null : primaryKeySerde.serializer();
        this.primaryKeyDeserializer = primaryKeySerde == null ? null : primaryKeySerde.deserializer();
        this.foreignKeyDeserializer = foreignKeySerde == null ? null : foreignKeySerde.deserializer();
        this.foreignKeySerializer = foreignKeySerde == null ? null : foreignKeySerde.serializer();
    }

    public void init(ProcessorContext<?, ?> context) {
        this.primaryKeySerdeTopic = this.undecoratedPrimaryKeySerdeTopicSupplier.get();
        this.foreignKeySerdeTopic = this.undecoratedForeignKeySerdeTopicSupplier.get();
        this.primaryKeySerializer = this.primaryKeySerializer == null ? context.keySerde().serializer() : this.primaryKeySerializer;
        this.primaryKeyDeserializer = this.primaryKeyDeserializer == null ? context.keySerde().deserializer() : this.primaryKeyDeserializer;
        this.foreignKeySerializer = this.foreignKeySerializer == null ? context.keySerde().serializer() : this.foreignKeySerializer;
        this.foreignKeyDeserializer = this.foreignKeyDeserializer == null ? context.keySerde().deserializer() : this.foreignKeyDeserializer;
    }

    Bytes toBytes(KO foreignKey, K primaryKey) {
        byte[] foreignKeySerializedData = this.foreignKeySerializer.serialize(this.foreignKeySerdeTopic, foreignKey);
        byte[] primaryKeySerializedData = this.primaryKeySerializer.serialize(this.primaryKeySerdeTopic, primaryKey);
        ByteBuffer buf = ByteBuffer.allocate(4 + foreignKeySerializedData.length + primaryKeySerializedData.length);
        buf.putInt(foreignKeySerializedData.length);
        buf.put(foreignKeySerializedData);
        buf.put(primaryKeySerializedData);
        return Bytes.wrap(buf.array());
    }

    public CombinedKey<KO, K> fromBytes(Bytes data) {
        byte[] dataArray = data.get();
        ByteBuffer dataBuffer = ByteBuffer.wrap(dataArray);
        int foreignKeyLength = dataBuffer.getInt();
        byte[] foreignKeyRaw = new byte[foreignKeyLength];
        dataBuffer.get(foreignKeyRaw, 0, foreignKeyLength);
        KO foreignKey = this.foreignKeyDeserializer.deserialize(this.foreignKeySerdeTopic, foreignKeyRaw);
        byte[] primaryKeyRaw = new byte[dataArray.length - foreignKeyLength - 4];
        dataBuffer.get(primaryKeyRaw, 0, primaryKeyRaw.length);
        K primaryKey = this.primaryKeyDeserializer.deserialize(this.primaryKeySerdeTopic, primaryKeyRaw);
        return new CombinedKey<KO, K>(foreignKey, primaryKey);
    }

    Bytes prefixBytes(KO key) {
        byte[] foreignKeySerializedData = this.foreignKeySerializer.serialize(this.foreignKeySerdeTopic, key);
        ByteBuffer buf = ByteBuffer.allocate(4 + foreignKeySerializedData.length);
        buf.putInt(foreignKeySerializedData.length);
        buf.put(foreignKeySerializedData);
        return Bytes.wrap(buf.array());
    }
}

