/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class ChangedDeserializer<T>
implements Deserializer<Change<T>>,
WrappingNullableDeserializer<Change<T>, Void, T> {
    private static final int ENCODING_FLAG_SIZE = 1;
    private static final int IS_LATEST_FLAG_SIZE = 1;
    private Deserializer<T> inner;

    public ChangedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    public Deserializer<T> inner() {
        return this.inner;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.inner == null) {
            this.inner = getter.valueSerde().deserializer();
        }
    }

    @Override
    public Change<T> deserialize(String topic, Headers headers, byte[] data) {
        boolean isLatest;
        byte[] oldData;
        byte[] newData;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte encodingFlag = buffer.get(data.length - 1);
        switch (encodingFlag) {
            case 0: {
                newData = null;
                int oldDataLength = data.length - 1;
                oldData = new byte[oldDataLength];
                buffer.get(oldData);
                isLatest = true;
                break;
            }
            case 1: {
                oldData = null;
                int newDataLength = data.length - 1;
                newData = new byte[newDataLength];
                buffer.get(newData);
                isLatest = true;
                break;
            }
            case 2: {
                int newDataLength = ByteUtils.readVarint(buffer);
                newData = new byte[newDataLength];
                buffer.get(newData);
                int oldDataLength = buffer.capacity() - buffer.position() - 1;
                oldData = new byte[oldDataLength];
                buffer.get(oldData);
                isLatest = true;
                break;
            }
            case 3: {
                newData = null;
                int oldDataLength = data.length - 1 - 1;
                oldData = new byte[oldDataLength];
                buffer.get(oldData);
                isLatest = this.readIsLatestFlag(buffer);
                break;
            }
            case 4: {
                oldData = null;
                int newDataLength = data.length - 1 - 1;
                newData = new byte[newDataLength];
                buffer.get(newData);
                isLatest = this.readIsLatestFlag(buffer);
                break;
            }
            case 5: {
                int newDataLength = ByteUtils.readVarint(buffer);
                newData = new byte[newDataLength];
                buffer.get(newData);
                int oldDataLength = buffer.capacity() - buffer.position() - 1 - 1;
                oldData = new byte[oldDataLength];
                buffer.get(oldData);
                isLatest = this.readIsLatestFlag(buffer);
                break;
            }
            default: {
                throw new StreamsException("Encountered unknown byte value `" + encodingFlag + "` for encodingFlag in ChangedDeserializer.");
            }
        }
        return new Change<T>(this.inner.deserialize(topic, headers, newData), this.inner.deserialize(topic, headers, oldData), isLatest);
    }

    private boolean readIsLatestFlag(ByteBuffer buffer) {
        byte isLatestFlag = buffer.get(buffer.capacity() - 1 - 1);
        if (isLatestFlag == 1) {
            return true;
        }
        if (isLatestFlag == 0) {
            return false;
        }
        throw new StreamsException("Encountered unexpected byte value `" + isLatestFlag + "` for isLatestFlag in ChangedDeserializer.");
    }

    @Override
    public Change<T> deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

