/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateImageResponse;
import java.io.InputStream;
import java.util.Objects;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;

public class CreateImageCmdImpl
extends AbstrDockerCmd<CreateImageCmd, CreateImageResponse>
implements CreateImageCmd {
    private String repository;
    private String tag;
    private String platform;
    private InputStream imageStream;

    public CreateImageCmdImpl(CreateImageCmd.Exec exec, String repository, InputStream imageStream) {
        super(exec);
        this.withRepository(repository);
        this.withImageStream(imageStream);
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public InputStream getImageStream() {
        return this.imageStream;
    }

    @Override
    public CreateImageCmdImpl withRepository(String repository) {
        Objects.requireNonNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public CreateImageCmdImpl withImageStream(InputStream imageStream) {
        Objects.requireNonNull(imageStream, "imageStream was not specified");
        this.imageStream = imageStream;
        return this;
    }

    @Override
    public CreateImageCmdImpl withTag(String tag) {
        Objects.requireNonNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public CreateImageCmd withPlatform(String platform) {
        this.platform = platform;
        return this;
    }
}

