/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.transport.NamedPipeSocket;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.transport.UnixSocket;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.Closeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.SocketFactory;
import org.jetbrains.annotations.Nullable;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.AuthDelegatingDockerClientConfig;
import org.testcontainers.dockerclient.DockerClientConfigUtils;
import org.testcontainers.dockerclient.EnvironmentAndSystemPropertyClientProviderStrategy;
import org.testcontainers.dockerclient.HeadersAddingDockerHttpClient;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TestcontainersHostPropertyClientProviderStrategy;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.RemoteApiVersion;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.utility.TestcontainersConfiguration;

public abstract class DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(DockerClientProviderStrategy.class);
    private final AtomicReference<Object> dockerClient = new AtomicReference();
    private String dockerHostIpAddress;
    private Info info;
    private final RateLimiter PING_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(10, TimeUnit.SECONDS).withConstantThroughput().build();
    private static final AtomicBoolean FAIL_FAST_ALWAYS = new AtomicBoolean(false);

    public abstract String getDescription();

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isPersistable() {
        return true;
    }

    public boolean allowUserOverrides() {
        return true;
    }

    public String getRemoteDockerUnixSocketPath() {
        return null;
    }

    protected int getPriority() {
        return 0;
    }

    public abstract TransportConfig getTransportConfig() throws InvalidConfigurationException;

    @Deprecated
    public DockerClient getClient() {
        DockerClient dockerClient = this.getDockerClient();
        try {
            Unreliables.retryUntilSuccess(30, TimeUnit.SECONDS, () -> this.PING_RATE_LIMITER.getWhenReady(() -> {
                log.debug("Pinging docker daemon...");
                dockerClient.pingCmd().exec();
                log.debug("Pinged");
                return true;
            }));
        }
        catch (TimeoutException e) {
            IOUtils.closeQuietly((Closeable)dockerClient);
            throw e;
        }
        return dockerClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean test() {
        InetSocketAddress socketAddress;
        Callable<Socket> socketProvider;
        TransportConfig transportConfig = this.getTransportConfig();
        URI dockerHost = transportConfig.getDockerHost();
        switch (dockerHost.getScheme()) {
            case "tcp": 
            case "http": 
            case "https": {
                SocketFactory socketFactory = SocketFactory.getDefault();
                SSLConfig sslConfig = transportConfig.getSslConfig();
                if (sslConfig != null) {
                    try {
                        socketFactory = sslConfig.getSSLContext().getSocketFactory();
                    }
                    catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        log.warn("Exception while creating SSLSocketFactory", (Throwable)e);
                        return false;
                    }
                }
                socketProvider = socketFactory::createSocket;
                socketAddress = new InetSocketAddress(dockerHost.getHost(), dockerHost.getPort());
                break;
            }
            case "unix": 
            case "npipe": {
                if (!new File(dockerHost.getPath()).exists()) {
                    log.debug("DOCKER_HOST socket file '{}' does not exist", (Object)dockerHost.getPath());
                    return false;
                }
                socketProvider = () -> {
                    switch (dockerHost.getScheme()) {
                        case "unix": {
                            return UnixSocket.get(dockerHost.getPath());
                        }
                        case "npipe": {
                            return new NamedPipeSocket(dockerHost.getPath());
                        }
                    }
                    throw new IllegalStateException("Unexpected scheme " + dockerHost.getScheme());
                };
                socketAddress = new InetSocketAddress("localhost", 2375);
                break;
            }
            default: {
                log.warn("Unknown DOCKER_HOST scheme {}, skipping the strategy test...", (Object)dockerHost.getScheme());
                return true;
            }
        }
        try (Socket socket = socketProvider.call();){
            Awaitility.await().atMost(TestcontainersConfiguration.getInstance().getClientPingTimeout().intValue(), TimeUnit.SECONDS).pollInterval(Duration.ofMillis(200L)).pollDelay(Duration.ofSeconds(0L)).untilAsserted(() -> socket.connect(socketAddress));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("DOCKER_HOST {} is not listening", (Object)dockerHost, (Object)e);
            return false;
        }
    }

    public static DockerClientProviderStrategy getFirstValidStrategy(List<DockerClientProviderStrategy> strategies) {
        if (FAIL_FAST_ALWAYS.get()) {
            throw new IllegalStateException("Previous attempts to find a Docker environment failed. Will not retry. Please see logs and check configuration");
        }
        ArrayList configurationFailures = new ArrayList();
        ArrayList<DockerClientProviderStrategy> allStrategies = new ArrayList<DockerClientProviderStrategy>();
        allStrategies.add(new TestcontainersHostPropertyClientProviderStrategy());
        allStrategies.add(new EnvironmentAndSystemPropertyClientProviderStrategy());
        DockerClientProviderStrategy.loadConfiguredStrategy().ifPresent(allStrategies::add);
        strategies.stream().sorted(Comparator.comparing(DockerClientProviderStrategy::getPriority).reversed()).collect(Collectors.toCollection(() -> allStrategies));
        Predicate<DockerClientProviderStrategy> distinctStrategyClassPredicate = new Predicate<DockerClientProviderStrategy>(){
            final Set<Class<? extends DockerClientProviderStrategy>> classes = new HashSet<Class<? extends DockerClientProviderStrategy>>();

            @Override
            public boolean test(DockerClientProviderStrategy dockerClientProviderStrategy) {
                return this.classes.add(dockerClientProviderStrategy.getClass());
            }
        };
        return allStrategies.stream().filter(distinctStrategyClassPredicate).filter(DockerClientProviderStrategy::isApplicable).filter(strategy -> DockerClientProviderStrategy.tryOutStrategy(configurationFailures, strategy)).findFirst().orElseThrow(() -> {
            log.error("Could not find a valid Docker environment. Please check configuration. Attempted configurations were:\n" + configurationFailures.stream().map(it -> "\t" + it).collect(Collectors.joining("\n")) + "As no valid configuration was found, execution cannot continue.\nSee https://java.testcontainers.org/on_failure.html for more details.");
            FAIL_FAST_ALWAYS.set(true);
            return new IllegalStateException("Could not find a valid Docker environment. Please see logs and check configuration");
        });
    }

    private static boolean tryOutStrategy(List<String> configurationFailures, DockerClientProviderStrategy strategy) {
        try {
            log.debug("Trying out strategy: {}", (Object)strategy.getClass().getSimpleName());
            if (!strategy.test()) {
                log.debug("strategy {} did not pass the test", (Object)strategy.getClass().getSimpleName());
                return false;
            }
            strategy.info = (Info)strategy.getDockerClient().infoCmd().exec();
            log.info("Found Docker environment with {}", (Object)strategy.getDescription());
            log.debug("Transport type: '{}', Docker host: '{}'", (Object)TestcontainersConfiguration.getInstance().getTransportType(), (Object)strategy.getTransportConfig().getDockerHost());
            log.debug("Checking Docker OS type for {}", (Object)strategy.getDescription());
            String osType = strategy.getInfo().getOsType();
            if (StringUtils.isBlank(osType)) {
                log.warn("Could not determine Docker OS type");
            } else if (!osType.equals("linux")) {
                log.warn("{} is currently not supported", (Object)osType);
                throw new InvalidConfigurationException(osType + " containers are currently not supported");
            }
            if (strategy.isPersistable()) {
                TestcontainersConfiguration.getInstance().updateUserConfig("docker.client.strategy", strategy.getClass().getName());
            }
            return true;
        }
        catch (Exception | ExceptionInInitializerError | NoClassDefFoundError e) {
            @Nullable String throwableMessage = e.getMessage();
            Throwable rootCause = Throwables.getRootCause(e);
            @Nullable String rootCauseMessage = rootCause.getMessage();
            String failureDescription = throwableMessage != null && throwableMessage.equals(rootCauseMessage) ? String.format("%s: failed with exception %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage) : String.format("%s: failed with exception %s (%s). Root cause %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage, rootCause.getClass().getSimpleName(), rootCauseMessage);
            configurationFailures.add(failureDescription);
            log.debug(failureDescription);
            return false;
        }
    }

    private static Optional<? extends DockerClientProviderStrategy> loadConfiguredStrategy() {
        String configuredDockerClientStrategyClassName = TestcontainersConfiguration.getInstance().getDockerClientStrategyClassName();
        return Stream.of(configuredDockerClientStrategyClassName).filter(Objects::nonNull).flatMap(it -> {
            try {
                Class<?> strategyClass = Thread.currentThread().getContextClassLoader().loadClass((String)it);
                return Stream.of(strategyClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                log.warn("Can't instantiate a strategy from {} (ClassNotFoundException). This probably means that cached configuration refers to a client provider class that is not available in this version of Testcontainers. Other strategies will be tried instead.", it);
                return Stream.empty();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("Can't instantiate a strategy from {}", it, (Object)e);
                return Stream.empty();
            }
        }).filter(DockerClientProviderStrategy::isPersistable).peek(strategy -> log.info("Loaded {} from ~/.testcontainers.properties, will try it first", (Object)strategy.getClass().getName())).findFirst();
    }

    public static DockerClient getClientForConfig(TransportConfig transportConfig) {
        ZerodepDockerHttpClient dockerHttpClient;
        String transportType;
        switch (transportType = TestcontainersConfiguration.getInstance().getTransportType()) {
            case "httpclient5": {
                dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(transportConfig.getDockerHost()).sslConfig(transportConfig.getSslConfig()).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transport type '" + transportType + "'");
            }
        }
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        if (configBuilder.build().getApiVersion() == RemoteApiVersion.UNKNOWN_VERSION) {
            configBuilder.withApiVersion(RemoteApiVersion.VERSION_1_32);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-tc-sid", DockerClientFactory.SESSION_ID);
        headers.put("User-Agent", String.format("tc-java/%s", DockerClientFactory.TESTCONTAINERS_VERSION));
        return DockerClientImpl.getInstance(new AuthDelegatingDockerClientConfig(configBuilder.withDockerHost(transportConfig.getDockerHost().toString()).build()), new HeadersAddingDockerHttpClient(dockerHttpClient, headers));
    }

    public synchronized String getDockerHostIpAddress() {
        if (this.dockerHostIpAddress == null) {
            this.dockerHostIpAddress = DockerClientProviderStrategy.resolveDockerHostIpAddress(this.getDockerClient(), this.getTransportConfig().getDockerHost(), this.allowUserOverrides());
        }
        return this.dockerHostIpAddress;
    }

    @VisibleForTesting
    static String resolveDockerHostIpAddress(DockerClient client, URI dockerHost, boolean allowUserOverrides) {
        String hostOverride;
        if (allowUserOverrides && !StringUtils.isBlank(hostOverride = System.getenv("TESTCONTAINERS_HOST_OVERRIDE"))) {
            return hostOverride;
        }
        switch (dockerHost.getScheme()) {
            case "http": 
            case "https": 
            case "tcp": {
                return dockerHost.getHost();
            }
            case "unix": 
            case "npipe": {
                if (DockerClientConfigUtils.IN_A_CONTAINER) {
                    return client.inspectNetworkCmd().withNetworkId("bridge").exec().getIpam().getConfig().stream().filter(it -> it.getGateway() != null).findAny().map(Network.Ipam.Config::getGateway).orElseGet(() -> DockerClientConfigUtils.getDefaultGateway().orElse("localhost"));
                }
                return "localhost";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient getDockerClient() {
        Object value = this.dockerClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.dockerClient;
            synchronized (atomicReference) {
                value = this.dockerClient.get();
                if (value == null) {
                    DockerClient actualValue = DockerClientProviderStrategy.getClientForConfig(this.getTransportConfig());
                    value = actualValue == null ? this.dockerClient : actualValue;
                    this.dockerClient.set(value);
                }
            }
        }
        return (DockerClient)(value == this.dockerClient ? null : value);
    }

    public Info getInfo() {
        return this.info;
    }
}

