/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateConfigCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateSecretCmd;
import com.github.dockerjava.api.command.CreateServiceCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InitializeSwarmCmd;
import com.github.dockerjava.api.command.InspectConfigCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectServiceCmd;
import com.github.dockerjava.api.command.InspectSwarmCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.JoinSwarmCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.LeaveSwarmCmd;
import com.github.dockerjava.api.command.ListConfigsCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.command.ListServicesCmd;
import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageAsyncCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.LogSwarmObjectCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveConfigCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveSecretCmd;
import com.github.dockerjava.api.command.RemoveServiceCmd;
import com.github.dockerjava.api.command.RemoveSwarmNodeCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.ResizeContainerCmd;
import com.github.dockerjava.api.command.ResizeExecCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.UpdateServiceCmd;
import com.github.dockerjava.api.command.UpdateSwarmCmd;
import com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PruneType;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.SwarmSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.AuditLogger;

class AuditLoggingDockerClient
implements DockerClient {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingDockerClient.class);
    private final DockerClient wrappedClient;

    public AuditLoggingDockerClient(DockerClient wrappedClient) {
        this.wrappedClient = wrappedClient;
    }

    @Override
    public CreateContainerCmd createContainerCmd(@NotNull String image) {
        return this.wrappedCommand(CreateContainerCmd.class, this.wrappedClient.createContainerCmd(image), (cmd, res) -> AuditLogger.doLog("CREATE", image, res.getId(), cmd), (cmd, e) -> AuditLogger.doLog("CREATE", image, null, cmd, e));
    }

    @Override
    public StartContainerCmd startContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StartContainerCmd.class, this.wrappedClient.startContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("START", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("START", null, containerId, cmd, e));
    }

    @Override
    public RemoveContainerCmd removeContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(RemoveContainerCmd.class, this.wrappedClient.removeContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("REMOVE", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE", null, containerId, cmd, e));
    }

    @Override
    public StopContainerCmd stopContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StopContainerCmd.class, this.wrappedClient.stopContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("STOP", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("STOP", null, containerId, cmd, e));
    }

    @Override
    public KillContainerCmd killContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(KillContainerCmd.class, this.wrappedClient.killContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("KILL", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("KILL", null, containerId, cmd, e));
    }

    @Override
    public CreateNetworkCmd createNetworkCmd() {
        return this.wrappedCommand(CreateNetworkCmd.class, this.wrappedClient.createNetworkCmd(), (cmd, res) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd, e));
    }

    @Override
    public RemoveNetworkCmd removeNetworkCmd(@NotNull String networkId) {
        return this.wrappedCommand(RemoveNetworkCmd.class, this.wrappedClient.removeNetworkCmd(networkId), (cmd, res) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd, e));
    }

    private <T extends SyncDockerCmd<R>, R> T wrappedCommand(Class<T> clazz, T cmd, BiConsumer<T, R> successConsumer, BiConsumer<T, Exception> failureConsumer) {
        return (T)((SyncDockerCmd)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (method.getName().equals("exec")) {
                try {
                    Object r = method.invoke((Object)cmd, args);
                    successConsumer.accept(cmd, r);
                    return r;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                        e = (Exception)e.getCause();
                    }
                    failureConsumer.accept(cmd, e);
                    throw e;
                }
            }
            return method.invoke((Object)cmd, args);
        }));
    }

    @Override
    public AuthConfig authConfig() throws DockerException {
        return this.wrappedClient.authConfig();
    }

    @Override
    public AuthCmd authCmd() {
        return this.wrappedClient.authCmd();
    }

    @Override
    public InfoCmd infoCmd() {
        return this.wrappedClient.infoCmd();
    }

    @Override
    public PingCmd pingCmd() {
        return this.wrappedClient.pingCmd();
    }

    @Override
    public VersionCmd versionCmd() {
        return this.wrappedClient.versionCmd();
    }

    @Override
    public PullImageCmd pullImageCmd(String arg0) {
        return this.wrappedClient.pullImageCmd(arg0);
    }

    @Override
    public PushImageCmd pushImageCmd(String arg0) {
        return this.wrappedClient.pushImageCmd(arg0);
    }

    @Override
    public PushImageCmd pushImageCmd(Identifier arg0) {
        return this.wrappedClient.pushImageCmd(arg0);
    }

    @Override
    public CreateImageCmd createImageCmd(String arg0, InputStream arg1) {
        return this.wrappedClient.createImageCmd(arg0, arg1);
    }

    @Override
    public LoadImageCmd loadImageCmd(InputStream arg0) {
        return this.wrappedClient.loadImageCmd(arg0);
    }

    @Override
    public LoadImageAsyncCmd loadImageAsyncCmd(InputStream arg0) {
        return this.wrappedClient.loadImageAsyncCmd(arg0);
    }

    @Override
    public SearchImagesCmd searchImagesCmd(String arg0) {
        return this.wrappedClient.searchImagesCmd(arg0);
    }

    @Override
    public RemoveImageCmd removeImageCmd(String arg0) {
        return this.wrappedClient.removeImageCmd(arg0);
    }

    @Override
    public ListImagesCmd listImagesCmd() {
        return this.wrappedClient.listImagesCmd();
    }

    @Override
    public InspectImageCmd inspectImageCmd(String arg0) {
        return this.wrappedClient.inspectImageCmd(arg0);
    }

    @Override
    public SaveImageCmd saveImageCmd(String arg0) {
        return this.wrappedClient.saveImageCmd(arg0);
    }

    @Override
    public SaveImagesCmd saveImagesCmd() {
        return this.wrappedClient.saveImagesCmd();
    }

    @Override
    public ListContainersCmd listContainersCmd() {
        return this.wrappedClient.listContainersCmd();
    }

    @Override
    public ExecCreateCmd execCreateCmd(String arg0) {
        return this.wrappedClient.execCreateCmd(arg0);
    }

    @Override
    public ResizeExecCmd resizeExecCmd(String arg0) {
        return this.wrappedClient.resizeExecCmd(arg0);
    }

    @Override
    public InspectContainerCmd inspectContainerCmd(String arg0) {
        return this.wrappedClient.inspectContainerCmd(arg0);
    }

    @Override
    public WaitContainerCmd waitContainerCmd(String arg0) {
        return this.wrappedClient.waitContainerCmd(arg0);
    }

    @Override
    public AttachContainerCmd attachContainerCmd(String arg0) {
        return this.wrappedClient.attachContainerCmd(arg0);
    }

    @Override
    public ExecStartCmd execStartCmd(String arg0) {
        return this.wrappedClient.execStartCmd(arg0);
    }

    @Override
    public InspectExecCmd inspectExecCmd(String arg0) {
        return this.wrappedClient.inspectExecCmd(arg0);
    }

    @Override
    public LogContainerCmd logContainerCmd(String arg0) {
        return this.wrappedClient.logContainerCmd(arg0);
    }

    @Override
    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String arg0, String arg1) {
        return this.wrappedClient.copyArchiveFromContainerCmd(arg0, arg1);
    }

    @Override
    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String arg0, String arg1) {
        return this.wrappedClient.copyFileFromContainerCmd(arg0, arg1);
    }

    @Override
    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String arg0) {
        return this.wrappedClient.copyArchiveToContainerCmd(arg0);
    }

    @Override
    public ContainerDiffCmd containerDiffCmd(String arg0) {
        return this.wrappedClient.containerDiffCmd(arg0);
    }

    @Override
    public UpdateContainerCmd updateContainerCmd(String arg0) {
        return this.wrappedClient.updateContainerCmd(arg0);
    }

    @Override
    public RenameContainerCmd renameContainerCmd(String arg0) {
        return this.wrappedClient.renameContainerCmd(arg0);
    }

    @Override
    public RestartContainerCmd restartContainerCmd(String arg0) {
        return this.wrappedClient.restartContainerCmd(arg0);
    }

    @Override
    public ResizeContainerCmd resizeContainerCmd(String arg0) {
        return this.wrappedClient.resizeContainerCmd(arg0);
    }

    @Override
    public CommitCmd commitCmd(String arg0) {
        return this.wrappedClient.commitCmd(arg0);
    }

    @Override
    public BuildImageCmd buildImageCmd() {
        return this.wrappedClient.buildImageCmd();
    }

    @Override
    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return this.wrappedClient.buildImageCmd(dockerFileOrFolder);
    }

    @Override
    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return this.wrappedClient.buildImageCmd(tarInputStream);
    }

    @Override
    public TopContainerCmd topContainerCmd(String containerId) {
        return this.wrappedClient.topContainerCmd(containerId);
    }

    @Override
    public TagImageCmd tagImageCmd(String imageId, String imageNameWithRepository, String tag) {
        return this.wrappedClient.tagImageCmd(imageId, imageNameWithRepository, tag);
    }

    @Override
    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return this.wrappedClient.pauseContainerCmd(containerId);
    }

    @Override
    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return this.wrappedClient.unpauseContainerCmd(containerId);
    }

    @Override
    public EventsCmd eventsCmd() {
        return this.wrappedClient.eventsCmd();
    }

    @Override
    public StatsCmd statsCmd(String containerId) {
        return this.wrappedClient.statsCmd(containerId);
    }

    @Override
    public CreateVolumeCmd createVolumeCmd() {
        return this.wrappedClient.createVolumeCmd();
    }

    @Override
    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return this.wrappedClient.inspectVolumeCmd(name);
    }

    @Override
    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return this.wrappedClient.removeVolumeCmd(name);
    }

    @Override
    public ListVolumesCmd listVolumesCmd() {
        return this.wrappedClient.listVolumesCmd();
    }

    @Override
    public ListNetworksCmd listNetworksCmd() {
        return this.wrappedClient.listNetworksCmd();
    }

    @Override
    public InspectNetworkCmd inspectNetworkCmd() {
        return this.wrappedClient.inspectNetworkCmd();
    }

    @Override
    public ConnectToNetworkCmd connectToNetworkCmd() {
        return this.wrappedClient.connectToNetworkCmd();
    }

    @Override
    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return this.wrappedClient.disconnectFromNetworkCmd();
    }

    @Override
    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.initializeSwarmCmd(swarmSpec);
    }

    @Override
    public InspectSwarmCmd inspectSwarmCmd() {
        return this.wrappedClient.inspectSwarmCmd();
    }

    @Override
    public JoinSwarmCmd joinSwarmCmd() {
        return this.wrappedClient.joinSwarmCmd();
    }

    @Override
    public LeaveSwarmCmd leaveSwarmCmd() {
        return this.wrappedClient.leaveSwarmCmd();
    }

    @Override
    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.updateSwarmCmd(swarmSpec);
    }

    @Override
    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return this.wrappedClient.updateSwarmNodeCmd();
    }

    @Override
    public RemoveSwarmNodeCmd removeSwarmNodeCmd(String swarmNodeId) {
        return this.wrappedClient.removeSwarmNodeCmd(swarmNodeId);
    }

    @Override
    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return this.wrappedClient.listSwarmNodesCmd();
    }

    @Override
    public ListServicesCmd listServicesCmd() {
        return this.wrappedClient.listServicesCmd();
    }

    @Override
    public CreateServiceCmd createServiceCmd(ServiceSpec serviceSpec) {
        return this.wrappedClient.createServiceCmd(serviceSpec);
    }

    @Override
    public InspectServiceCmd inspectServiceCmd(String serviceId) {
        return this.wrappedClient.inspectServiceCmd(serviceId);
    }

    @Override
    public UpdateServiceCmd updateServiceCmd(String serviceId, ServiceSpec serviceSpec) {
        return this.wrappedClient.updateServiceCmd(serviceId, serviceSpec);
    }

    @Override
    public RemoveServiceCmd removeServiceCmd(String serviceId) {
        return this.wrappedClient.removeServiceCmd(serviceId);
    }

    @Override
    public ListTasksCmd listTasksCmd() {
        return this.wrappedClient.listTasksCmd();
    }

    @Override
    public LogSwarmObjectCmd logServiceCmd(String serviceId) {
        return this.wrappedClient.logServiceCmd(serviceId);
    }

    @Override
    public LogSwarmObjectCmd logTaskCmd(String taskId) {
        return this.wrappedClient.logTaskCmd(taskId);
    }

    @Override
    public PruneCmd pruneCmd(PruneType pruneType) {
        return this.wrappedClient.pruneCmd(pruneType);
    }

    @Override
    public ListSecretsCmd listSecretsCmd() {
        return this.wrappedClient.listSecretsCmd();
    }

    @Override
    public CreateSecretCmd createSecretCmd(SecretSpec secretSpec) {
        return this.wrappedClient.createSecretCmd(secretSpec);
    }

    @Override
    public RemoveSecretCmd removeSecretCmd(String secretId) {
        return this.wrappedClient.removeSecretCmd(secretId);
    }

    @Override
    public ListConfigsCmd listConfigsCmd() {
        return this.wrappedClient.listConfigsCmd();
    }

    @Override
    public CreateConfigCmd createConfigCmd() {
        return this.wrappedClient.createConfigCmd();
    }

    @Override
    public InspectConfigCmd inspectConfigCmd(String configId) {
        return this.wrappedClient.inspectConfigCmd(configId);
    }

    @Override
    public RemoveConfigCmd removeConfigCmd(String configId) {
        return this.wrappedClient.removeConfigCmd(configId);
    }

    @Override
    public void close() throws IOException {
        this.wrappedClient.close();
    }

    private static interface InterceptedMethods {
        public CreateContainerCmd createContainerCmd(String var1);

        public StartContainerCmd startContainerCmd(String var1);

        public RemoveContainerCmd removeContainerCmd(String var1);

        public StopContainerCmd stopContainerCmd(String var1);

        public KillContainerCmd killContainerCmd(String var1);

        public CreateNetworkCmd createNetworkCmd();

        public RemoveNetworkCmd removeNetworkCmd(String var1);
    }
}

