/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.util.AbstractInterner;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import org.jetbrains.annotations.NotNull;

public class Bit8StringInterner
extends AbstractInterner<String> {
    private static final StringBuilderPool SBP = new StringBuilderPool();

    public Bit8StringInterner(int capacity) {
        super(capacity);
    }

    @Override
    @NotNull
    protected String getValue(@NotNull BytesStore cs, @NonNegative int length) throws IllegalStateException, BufferUnderflowException {
        StringBuilder sb = SBP.acquireStringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append((char)cs.readUnsignedByte(cs.readPosition() + (long)i));
        }
        return sb.toString();
    }
}

