/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.ThrowingLongSupplier;
import org.jetbrains.annotations.NotNull;

public class TextLongReference
extends AbstractReference
implements LongReference {
    static final int VALUE = 34;
    private static final byte[] template = "!!atomic {  locked: false, value: 00000000000000000000 }".getBytes(StandardCharsets.ISO_8859_1);
    private static final int FALSE = BytesUtil.asInt("fals");
    private static final int TRUE = BytesUtil.asInt(" tru");
    private static final long UNINITIALIZED = 0L;
    private static final long LONG_TRUE = 1L;
    private static final long LONG_FALSE = 0L;
    private static final int LOCKED = 20;
    private static final int DIGITS = 20;

    public static void write(@NotNull Bytes<?> bytes, @NonNegative long value) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        long position = bytes.writePosition();
        bytes.write(template);
        bytes.append(position + 34L, value, 20);
    }

    private <T extends Exception> long withLock(@NotNull ThrowingLongSupplier<T> call) throws IllegalStateException {
        try {
            long valueOffset = this.offset + 20L;
            int value = this.bytes.readVolatileInt(valueOffset);
            if (value != FALSE && value != TRUE) {
                throw new IllegalStateException("Not a lock value");
            }
            while (!this.bytes.compareAndSwapInt(valueOffset, FALSE, TRUE)) {
            }
            long t = call.getAsLong();
            this.bytes.writeOrderedInt(valueOffset, FALSE);
            return t;
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        if (length != (long)template.length) {
            throw new IllegalArgumentException();
        }
        long newOffset = BytesUtil.roundUpTo8ByteAlign(offset);
        for (long i = offset; i < newOffset; ++i) {
            bytes.writeByte(i, (byte)32);
        }
        super.bytesStore(bytes, newOffset, length);
        if (bytes.readLong(newOffset) == 0L) {
            bytes.write(newOffset, template);
        }
    }

    @Override
    public long getValue() throws IllegalStateException {
        return this.withLock(() -> this.bytes.parseLong(this.offset + 34L));
    }

    @Override
    public void setValue(long value) throws IllegalStateException {
        this.withLock(() -> {
            this.bytes.append(this.offset + 34L, value, 20);
            return 1L;
        });
    }

    @Override
    public long maxSize() {
        return template.length;
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return "value: " + this.getValue();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public long addValue(long delta) throws IllegalStateException {
        return this.withLock(() -> {
            long value = this.bytes.parseLong(this.offset + 34L) + delta;
            this.bytes.append(this.offset + 34L, value, 20);
            return value;
        });
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
        return this.withLock(() -> {
            if (this.bytes.parseLong(this.offset + 34L) == expected) {
                this.bytes.append(this.offset + 34L, value, 20);
                return 1L;
            }
            return 0L;
        }) == 1L;
    }
}

