/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.videoconferencing.jitsi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.commons.gwt.JsMapStringString;
import net.bluemind.core.container.api.IContainerManagementPromise;
import net.bluemind.core.container.api.gwt.endpoint.ContainerManagementGwtEndpoint;
import net.bluemind.core.container.model.acl.AccessControlEntry;
import net.bluemind.core.container.model.acl.Verb;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.resource.api.IResourcesPromise;
import net.bluemind.resource.api.ResourceDescriptor;
import net.bluemind.resource.api.gwt.endpoint.ResourcesGwtEndpoint;
import net.bluemind.ui.adminconsole.videoconferencing.jitsi.l10n.JitsiEditorConstants;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.common.client.forms.tag.UUID;
import net.bluemind.ui.editor.client.Editor;
import net.bluemind.videoconferencing.api.IVideoConferencingPromise;
import net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor;
import net.bluemind.videoconferencing.api.gwt.endpoint.VideoConferencingGwtEndpoint;

public class JitsiEditor
extends CompositeGwtWidgetElement {
    static final String TYPE = "bm.ac.JitsiEditor";
    private static final String PROVIDER_NAME = "Jitsi";
    private static final String PROVIDER_TYPE = "videoconferencing-jitsi";
    private static final String SETTINGS_URL = "url";
    private static final String SETTINGS_TEMPLATES = "templates";
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("fr", "en", "de", "es", "pt", "it", "hu", "nl", "pl", "ru", "sk", "uk", "zh");
    private static JitsiEditorUiBinder uiBinder = (JitsiEditorUiBinder)GWT.create(JitsiEditorUiBinder.class);
    @UiField
    TextBox serverUrl;
    @UiField
    Editor templateEditor;
    @UiField
    ListBox templateLanguagesComboBox;
    @UiField
    Button deleteBtn;
    private String domainUid;
    private String resourceUid;
    private Map<String, String> templatesByLanguage = new HashMap<String, String>();
    private int selectedTemplateIndex;

    @UiHandler(value={"deleteBtn"})
    void deleteClick(ClickEvent clickEvent) {
        if (Window.confirm((String)JitsiEditorConstants.INST.deleteBtnConfirm())) {
            this.removeResource();
        }
    }

    protected JitsiEditor() {
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        this.initWidget((Widget)hTMLPanel);
    }

    public static void registerType() {
        GwtWidgetElement.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new JitsiEditor();
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        String string2;
        super.loadModel(javaScriptObject);
        this.deleteBtn.setVisible(false);
        JsMapStringJsObject jsMapStringJsObject = (JsMapStringJsObject)javaScriptObject.cast();
        this.domainUid = jsMapStringJsObject.getString("domainUid");
        for (String string2 : SUPPORTED_LANGUAGES) {
            this.templateLanguagesComboBox.addItem(string2);
        }
        this.templateLanguagesComboBox.setSelectedIndex(0);
        this.selectedTemplateIndex = 0;
        this.templateLanguagesComboBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent changeEvent) {
                JitsiEditor.this.storeCurrentTemplate();
                JitsiEditor.this.selectedTemplateIndex = JitsiEditor.this.templateLanguagesComboBox.getSelectedIndex();
                JitsiEditor.this.templateEditor.setText(JitsiEditor.this.templatesByLanguage.get(SUPPORTED_LANGUAGES.get(JitsiEditor.this.selectedTemplateIndex)));
            }
        });
        string2 = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        string2.byType("bm-videoconferencing").thenAccept(arg_0 -> this.lambda$0((IResourcesPromise)string2, arg_0));
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
        String string = (String)this.serverUrl.asEditor().getValue();
        if (string != null) {
            if (this.resourceUid != null) {
                this.setResourceSettings(this.resourceUid);
            } else {
                String string2 = UUID.uuid();
                this.createResource(string2).thenAccept(void_ -> this.setResourceSettings(string2));
            }
        }
    }

    private CompletableFuture<Void> createResource(String string) {
        IVideoConferencingPromise iVideoConferencingPromise = new VideoConferencingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        return iVideoConferencingPromise.createResource(string, VideoConferencingResourceDescriptor.create((String)PROVIDER_NAME, (String)PROVIDER_TYPE, Arrays.asList(AccessControlEntry.create((String)this.domainUid, (Verb)Verb.Invitation))));
    }

    private void setResourceSettings(String string) {
        IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(string)}).promiseApi();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = (String)this.serverUrl.asEditor().getValue();
        hashMap.put(SETTINGS_URL, string2);
        this.storeCurrentTemplate();
        String string3 = JsonUtils.stringify((JavaScriptObject)JsMapStringString.create(this.templatesByLanguage));
        hashMap.put(SETTINGS_TEMPLATES, string3);
        iContainerManagementPromise.setSettings(hashMap);
    }

    private void removeResource() {
        IResourcesPromise iResourcesPromise = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        iResourcesPromise.delete(this.resourceUid).thenAccept(taskRef -> {
            this.templateLanguagesComboBox.setSelectedIndex(0);
            this.selectedTemplateIndex = 0;
            this.resourceUid = null;
            this.serverUrl.asEditor().setValue(null);
            this.templatesByLanguage = new HashMap<String, String>();
            this.templateEditor.setText(null);
        });
    }

    private void storeCurrentTemplate() {
        String string = this.templateEditor.getText();
        this.templatesByLanguage.put(SUPPORTED_LANGUAGES.get(this.selectedTemplateIndex), string);
    }

    private String getResourceSettingsContainer(String string) {
        return string + "-settings-container";
    }

    private /* synthetic */ void lambda$0(IResourcesPromise iResourcesPromise, List list) {
        if (list != null && !list.isEmpty()) {
            list.forEach(string -> iResourcesPromise.get(string).thenAccept(resourceDescriptor -> {
                boolean bl = false;
                int n = 0;
                while (n < resourceDescriptor.properties.size()) {
                    ResourceDescriptor.PropertyValue propertyValue = (ResourceDescriptor.PropertyValue)resourceDescriptor.properties.get(n);
                    if ("bm-videoconferencing-type".equals(propertyValue.propertyId) && PROVIDER_TYPE.equals(propertyValue.value)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    this.deleteBtn.setVisible(true);
                    this.resourceUid = string;
                    IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(this.resourceUid)}).promiseApi();
                    iContainerManagementPromise.getSettings().thenAccept(map -> {
                        String string;
                        String string2 = (String)map.get(SETTINGS_URL);
                        if (string2 != null) {
                            this.serverUrl.setValue((Object)string2);
                        }
                        if ((string = (String)map.get(SETTINGS_TEMPLATES)) != null) {
                            JavaScriptObject javaScriptObject = JsonUtils.safeEval((String)string);
                            JsMapStringString jsMapStringString = (JsMapStringString)javaScriptObject.cast();
                            this.templatesByLanguage = jsMapStringString.asMap();
                            this.templateEditor.setText(this.templatesByLanguage.get(SUPPORTED_LANGUAGES.get(0)));
                        }
                    });
                }
            }));
        }
    }

    static interface JitsiEditorUiBinder
    extends UiBinder<HTMLPanel, JitsiEditor> {
    }
}

