/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.importation.commons.pool;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;

import net.bluemind.lib.ldap.LdapProtocol;
import net.bluemind.system.importation.commons.Parameters;

public class LdapConnectionContext {
	public final LdapConnection ldapCon;
	public final LdapConnectionConfig ldapConnectionConfig;
	public final Parameters parameters;
	private boolean ldapConError = false;

	public LdapConnectionContext(LdapConnection ldapCon, LdapConnectionConfig ldapConnectionConfig,
			Parameters ldapParameters) {
		this.ldapCon = ldapCon;
		this.ldapConnectionConfig = ldapConnectionConfig;
		this.parameters = ldapParameters;
	}

	public LdapProtocol getConnectedProtocol() {
		if (ldapConnectionConfig.isUseSsl()) {
			return LdapProtocol.SSL;
		}

		if (ldapConnectionConfig.isUseTls()) {
			return LdapProtocol.TLS;
		}

		return LdapProtocol.PLAIN;
	}

	/**
	 * Set ldapCon status to error
	 * 
	 * @return
	 */
	public LdapConnectionContext setError() {
		ldapConError = true;
		return this;
	}

	/**
	 * Is ldapCon status set to error
	 * 
	 * @return
	 */
	public boolean isError() {
		return ldapConError;
	}
}
