/* BEGIN LICENSE
* Copyright © Blue Mind SAS, 2012-2025
*
* This file is part of BlueMind. BlueMind is a messaging and collaborative
* solution.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of either the GNU Affero General Public License as
* published by the Free Software Foundation (version 3 of the License).
*
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* See LICENSE.txt
* END LICENSE
*/

package net.bluemind.notes.service.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.persistence.DataSourceRouter;
import net.bluemind.core.rest.BmContext;
import net.bluemind.indexing.incremental.hooks.IIncrementalIndexingContainersHook;
import net.bluemind.lib.elasticsearch.ESearchActivator;
import net.bluemind.notes.api.INoteUids;
import net.bluemind.notes.persistence.VNoteIndexStore;

public class VNoteContainerHook implements IIncrementalIndexingContainersHook {
	private static final Logger logger = LoggerFactory.getLogger(VNoteContainerHook.class);

	@Override
	public void onContainerDeleted(BmContext ctx, String uid, String type) throws ServerFault {
		if (type.equals(INoteUids.TYPE)) {
			logger.info("delete all notes elements for container uid: {}", uid);
			Container cont = new Container();
			cont.uid = uid;
			VNoteIndexStore indexStore = new VNoteIndexStore(ESearchActivator.getClient(), cont,
					DataSourceRouter.location(ctx, cont.uid));
			indexStore.deleteAll();

		}

	}

}
