<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VNote.
 */
class VNote  {

  /*
   * @type Integer
   */
  public $height;

  /*
   * @type Integer
   */
  public $width;

  /*
   * @type Integer
   */
  public $posX;

  /*
   * @type Integer
   */
  public $posY;

  /*
   * @type VNoteColor
   */
  public $color;

  /*
   * @type String
   */
  public $body;

  /*
   * @type String
   */
  public $subject;

  /*
   * @type List
   */
  public $categories;

  /*
   * Constructor
   */
  public function __construct() {
    $this->height = null;
    $this->width = null;
    $this->posX = null;
    $this->posY = null;
    $this->body = "";
    $this->subject = "";
    $this->categories =  array();
  }

  public function toMap() {
    $data = array(    
        "height" => empty($this->height) ? null : $this->height,    
        "width" => empty($this->width) ? null : $this->width,    
        "posX" => empty($this->posX) ? null : $this->posX,    
        "posY" => empty($this->posY) ? null : $this->posY,    
        "color" => empty($this->color) ? null : $this->color,    
        "body" => empty($this->body) ? null : $this->body,    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "categories" => empty($this->categories) ? null : $this->categories);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
