/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.memory.pool.mmap;

import java.util.concurrent.atomic.AtomicLong;

public final class SizeRecorder {

	private final AtomicLong lockedInMemory;
	private final AtomicLong flushableMemory;

	public SizeRecorder() {
		this.lockedInMemory = new AtomicLong(0);
		this.flushableMemory = new AtomicLong(0);
	}

	public void updateLockedIn(long mem) {
		lockedInMemory.addAndGet(mem);
	}

	public void updateFlushable(long mem) {
		flushableMemory.addAndGet(mem);
	}

	public long lockedInMemory() {
		return lockedInMemory.get();
	}

	@Override
	public String toString() {
		return "Sizes{locked: " + mb(lockedInMemory.get()) + "M, flushable: " + mb(flushableMemory.get()) + "M}";
	}

	long mb(long bytes) {
		return bytes / 1024 / 1024;
	}
}
