/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.memory.pool.mmap;

import java.io.IOException;

import net.bluemind.memory.pool.api.IMMapPoolConfig;
import net.bluemind.memory.pool.api.IPoolFactory;
import net.bluemind.memory.pool.api.MemoryMappedPool;

public class PoolFactory implements IPoolFactory {

	@Override
	public IMMapPoolConfig defaultConfiguration() {
		return MMapPoolConfig.loadDefault();
	}

	@Override
	public MemoryMappedPool create(IMMapPoolConfig config) throws IOException {
		return MemoryMappedPoolImpl.create(config);
	}

}
