/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.mailbox.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.identity.api.Identity;
import net.bluemind.mailbox.identity.api.IdentityDescription;

public interface IMailboxIdentityStore {

	void create(Item mboxItem, String id, Identity identity) throws SQLException;

	void update(Item mboxItem, String id, Identity identity) throws SQLException;

	void delete(Item mboxItem, String id) throws SQLException;

	Identity get(Item mboxItem, String id) throws SQLException;

	void delete(Item item) throws SQLException;

	List<IdentityDescription> getDescriptions(ItemValue<Mailbox> mboxItemValue) throws SQLException;
}
