/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.mailbox.repository;

import java.sql.SQLException;

import net.bluemind.core.container.model.Item;
import net.bluemind.mailbox.api.MailFilter;
import net.bluemind.mailbox.api.rules.MailFilterRule;
import net.bluemind.mailbox.api.rules.RuleMoveDirection;
import net.bluemind.mailbox.api.rules.RuleMoveRelativePosition;

public interface IMailFilterStore {

	void set(Item item, MailFilter value) throws SQLException;

	void delete(Item item) throws SQLException;

	MailFilter get(Item item) throws SQLException;

	MailFilterRule getRule(Item item, long id) throws SQLException;

	long addRule(Item item, MailFilterRule value) throws SQLException;

	long addRule(Item item, RuleMoveRelativePosition position, long anchorId, MailFilterRule value) throws SQLException;

	void updateRule(Item item, long id, MailFilterRule value) throws SQLException;

	void deleteRule(Item item, long id) throws SQLException;

	void moveRule(Item item, long id, RuleMoveRelativePosition position, long anchorId) throws SQLException;

	void moveRule(Item item, long id, RuleMoveDirection direction) throws SQLException;

}
