/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.mailbox.persistence.factories;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.mailbox.persistence.MailboxStore;
import net.bluemind.mailbox.repository.IMailboxStore;
import net.bluemind.repository.provider.IContainerBoundFactory;

public class MailboxStoreFactory implements IContainerBoundFactory<IMailboxStore> {

	@Override
	public Class<IMailboxStore> factoryClass() {
		return IMailboxStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IMailboxStore instance(BmContext context, Container container) throws ServerFault {
		return new MailboxStore(context.getDataSource(), container);
	}

}
