<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Mailbox.
 */
class Mailbox  {

  /*
   * @type String
   */
  public $name;

  /*
   * @type boolean
   */
  public $system;

  /*
   * @type boolean
   */
  public $hidden;

  /*
   * @type boolean
   */
  public $archived;

  /*
   * @type MailboxType
   */
  public $type;

  /*
   * @type MailboxRouting
   */
  public $routing;

  /*
   * @type Collection
   */
  public $emails;

  /*
   * @type String
   */
  public $dataLocation;

  /*
   * @type Integer
   */
  public $quota;

  /*
   * Constructor
   */
  public function __construct() {
    $this->name = "";
    $this->system = false;
    $this->hidden = false;
    $this->archived = false;
    $this->emails =   new Collection();
    $this->dataLocation = "";
    $this->quota = null;
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "system" => empty($this->system) ? null : $this->system,    
        "hidden" => empty($this->hidden) ? null : $this->hidden,    
        "archived" => empty($this->archived) ? null : $this->archived,    
        "type" => empty($this->type) ? null : $this->type,    
        "routing" => empty($this->routing) ? null : $this->routing,    
        "emails" => empty($this->emails) ? null : $this->emails,    
        "dataLocation" => empty($this->dataLocation) ? null : $this->dataLocation,    
        "quota" => empty($this->quota) ? null : $this->quota);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
