<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterRuleFilterRange.
 */
class MailFilterRuleFilterRange extends MailFilterRuleFilter {

  /*
   * @type String
   */
  public $lowerBound;

  /*
   * @type String
   */
  public $upperBound;

  /*
   * @type boolean
   */
  public $inclusive;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->lowerBound = "";
    $this->upperBound = "";
    $this->inclusive = false;
  }

  public function toMap() {
    $data = array(    
        "lowerBound" => empty($this->lowerBound) ? null : $this->lowerBound,    
        "upperBound" => empty($this->upperBound) ? null : $this->upperBound,    
        "inclusive" => empty($this->inclusive) ? null : $this->inclusive);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
