<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterRuleCondition.
 */
class MailFilterRuleCondition  {

  /*
   * @type MailFilterRuleConditionOperator
   */
  public $operator;

  /*
   * @type MailFilterRuleFilter
   */
  public $filter;

  /*
   * @type List
   */
  public $conditions;

  /*
   * @type Map
   */
  public $clientProperties;

  /*
   * @type boolean
   */
  public $negate;

  /*
   * Constructor
   */
  public function __construct() {
    $this->filter =   new MailFilterRuleFilter();
    $this->conditions =  array();
    $this->clientProperties = array();
    $this->negate = false;
  }

  public function toMap() {
    $data = array(    
        "operator" => empty($this->operator) ? null : $this->operator,    
        "filter" => empty($this->filter) ? null : $this->filter,    
        "conditions" => empty($this->conditions) ? null : $this->conditions,    
        "clientProperties" => empty($this->clientProperties) ? null : $this->clientProperties,    
        "negate" => empty($this->negate) ? null : $this->negate);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
