<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterRuleActionReply.
 */
class MailFilterRuleActionReply extends MailFilterRuleAction {

  /*
   * @type String
   */
  public $subject;

  /*
   * @type String
   */
  public $plainBody;

  /*
   * @type String
   */
  public $htmlBody;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->subject = "";
    $this->plainBody = "";
    $this->htmlBody = "";
  }

  public function toMap() {
    $data = array(    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "plainBody" => empty($this->plainBody) ? null : $this->plainBody,    
        "htmlBody" => empty($this->htmlBody) ? null : $this->htmlBody);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
