/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.internal;

import java.util.function.Consumer;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.directory.api.ReservedIds;
import net.bluemind.mailbox.api.IMailboxes;
import net.bluemind.mailbox.api.Mailbox;

public interface IInCoreMailboxes extends IMailboxes {
	void checkAvailabilty(Mailbox mailbox) throws ServerFault;

	void sanitize(Mailbox mailbox) throws ServerFault;

	void validate(String uid, Mailbox mailbox) throws ServerFault;

	void created(String uid, Mailbox mailbox, Consumer<ReservedIds> reservedIdsConsumer) throws ServerFault;

	void updated(String uid, Mailbox previous, Mailbox mailbox, Consumer<ReservedIds> reservedIdsConsumer)
			throws ServerFault;

	void deleted(String uid, Mailbox mailbox) throws ServerFault;

	void deleteEmailByAlias(String alias) throws ServerFault;
}
