/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.mailbox.api.IMailboxMgmt.
 */

goog.provide('net.bluemind.mailbox.api.MailboxMgmtVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.mailbox.api.IMailboxMgmt API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient = function( sessionId , domainUid ) {
  this.sessionId = sessionId;
  this.base = '/mgmt/mailbox/{domainUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.mailbox.api.MailboxMgmtVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} numericIndex
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.addIndexToRing = function( numericIndex  ) {

  var postUri = "/{numericIndex}/_add_index";

  postUri = postUri.replace("{numericIndex}", goog.string.urlEncode(numericIndex));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.consolidateDomain = function() {

  var postUri = "/_consolidate";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.consolidateMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_consolidate";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} numericIndex
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.deleteIndexFromRing = function( numericIndex  ) {

  var postUri = "/{numericIndex}/_remove_index";

  postUri = postUri.replace("{numericIndex}", goog.string.urlEncode(numericIndex));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.getLiteStats = function() {

  var postUri = "/liteStats";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.getShardsStats = function() {

  var postUri = "/shardsStats";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {string} index
 * @param {boolean} deleteSource
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.moveIndex = function( mailboxUid ,  index ,  deleteSource  ) {

  var postUri = "/{mailboxUid}/_move_index";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};

  if (goog.isDefAndNotNull(index)) {
    params['index'] = index;
  }
  if (goog.isDefAndNotNull(deleteSource)) {
    params['deleteSource'] = deleteSource;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.resetMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_reset";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtVertxClient.prototype.respawnMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_respawn";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

