/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.mailbox.api.IMailboxes.
 */

goog.provide('net.bluemind.mailbox.api.MailboxesVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.mailbox.api.IMailboxes API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.mailbox.api.MailboxesVertxClient = function( sessionId , domainUid ) {
  this.sessionId = sessionId;
  this.base = '/mailboxes/{domainUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.mailbox.api.MailboxesVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.addDomainRule = function( rule  ) {

  var postUri = "/_rules";

  var params = {};



  var body = null;
  body = rule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.addMailboxRule = function( mailboxUid ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = rule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} position
 * @param {number} anchorId
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.addMailboxRuleRelative = function( mailboxUid ,  position ,  anchorId ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules/{position}/{anchorId}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{position}", goog.string.urlEncode(position));
  postUri = postUri.replace("{anchorId}", goog.string.urlEncode(anchorId));
  var params = {};



  var body = null;
  body = rule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.byEmail = function( email  ) {

  var postUri = "/_byemail";

  var params = {};

  if (goog.isDefAndNotNull(email)) {
    params['email'] = email;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} name
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.byName = function( name  ) {

  var postUri = "/_byname";

  var params = {};

  if (goog.isDefAndNotNull(name)) {
    params['name'] = name;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} email
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.byRouting = function( email  ) {

  var postUri = "/_byRouting";

  var params = {};

  if (goog.isDefAndNotNull(email)) {
    params['email'] = email;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} mailbox
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.create = function( uid ,  mailbox  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = mailbox;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.deleteDomainRule = function( id  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.deleteMailboxRule = function( mailboxUid ,  id  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getDomainFilter = function() {

  var postUri = "/_filter";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getDomainRule = function( id  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getDomainRules = function() {

  var postUri = "/_rules";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxAccessControlList = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_acls";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxConfig = function( uid  ) {

  var postUri = "/{uid}/_config";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxDelegationRule = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_delegationRule";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxFilter = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_filter";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxForwarding = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_forwarding";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxQuota = function( uid  ) {

  var postUri = "/{uid}/_quota";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxRule = function( mailboxUid ,  id  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxRules = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_rules";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {string} client
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxRulesByClient = function( mailboxUid ,  client  ) {

  var postUri = "/{mailboxUid}/_rulesByClient";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};

  if (goog.isDefAndNotNull(client)) {
    params['client'] = client;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getMailboxVacation = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_vacation";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.getUnreadMessagesCount = function() {

  var postUri = "/_unread";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.list = function() {

  var postUri = "/_list";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.listUids = function() {

  var postUri = "/_listUids";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} direction
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.moveMailboxRule = function( mailboxUid ,  id ,  direction  ) {

  var postUri = "/{mailboxUid}/_rules/{id}/{direction}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  postUri = postUri.replace("{direction}", goog.string.urlEncode(direction));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} position
 * @param {number} anchorId
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.moveMailboxRuleRelative = function( mailboxUid ,  id ,  position ,  anchorId  ) {

  var postUri = "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  postUri = postUri.replace("{position}", goog.string.urlEncode(position));
  postUri = postUri.replace("{anchorId}", goog.string.urlEncode(anchorId));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} filter
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setDomainFilter = function( filter  ) {

  var postUri = "/_filter";

  var params = {};



  var body = null;
  body = filter;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Array.<Object>} accessControlEntries
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setMailboxAccessControlList = function( mailboxUid ,  accessControlEntries  ) {

  var postUri = "/{mailboxUid}/_acls";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = accessControlEntries;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} delegationRule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setMailboxDelegationRule = function( mailboxUid ,  delegationRule  ) {

  var postUri = "/{mailboxUid}/_delegationRule";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = delegationRule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} filter
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setMailboxFilter = function( mailboxUid ,  filter  ) {

  var postUri = "/{mailboxUid}/_filter";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = filter;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} forwarding
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setMailboxForwarding = function( mailboxUid ,  forwarding  ) {

  var postUri = "/{mailboxUid}/_forwarding";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = forwarding;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} vacation
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.setMailboxVacation = function( mailboxUid ,  vacation  ) {

  var postUri = "/{mailboxUid}/_vacation";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  var params = {};



  var body = null;
  body = vacation;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} mailbox
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.update = function( uid ,  mailbox  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = mailbox;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.updateDomainRule = function( id ,  rule  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = rule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesVertxClient.prototype.updateMailboxRule = function( mailboxUid ,  id ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = rule;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

