/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.mailbox.api.IMailboxes.
 */

goog.provide('net.bluemind.mailbox.api.MailboxesClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.mailbox.api.IMailboxes API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.mailbox.api.MailboxesClient = function(rpc, base , domainUid ) {
  goog.base(this, rpc, base);
  this.base += '/mailboxes/{domainUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.mailbox.api.MailboxesClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.addDomainRule = function( rule  ) {

  var postUri = "/_rules";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "addDomainRule_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = rule;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.addMailboxRule = function( mailboxUid ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "addMailboxRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = rule;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} position
 * @param {number} anchorId
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.addMailboxRuleRelative = function( mailboxUid ,  position ,  anchorId ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules/{position}/{anchorId}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{position}", goog.string.urlEncode(position));
  postUri = postUri.replace("{anchorId}", goog.string.urlEncode(anchorId));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "addMailboxRuleRelative_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + position
                                  + anchorId
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = rule;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.byEmail = function( email  ) {

  var postUri = "/_byemail";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(email)) {
    url.getQueryData().add('email', email);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "byEmail_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} name
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.byName = function( name  ) {

  var postUri = "/_byname";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(name)) {
    url.getQueryData().add('name', name);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "byName_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} email
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.byRouting = function( email  ) {

  var postUri = "/_byRouting";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(email)) {
    url.getQueryData().add('email', email);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "byRouting_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} mailbox
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.create = function( uid ,  mailbox  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = mailbox;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.deleteDomainRule = function( id  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteDomainRule_" 
                                  + this.domainUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.deleteMailboxRule = function( mailboxUid ,  id  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteMailboxRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getDomainFilter = function() {

  var postUri = "/_filter";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getDomainFilter_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getDomainRule = function( id  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getDomainRule_" 
                                  + this.domainUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getDomainRules = function() {

  var postUri = "/_rules";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getDomainRules_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxAccessControlList = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_acls";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxAccessControlList_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxConfig = function( uid  ) {

  var postUri = "/{uid}/_config";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxConfig_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxDelegationRule = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_delegationRule";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxDelegationRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxFilter = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_filter";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxFilter_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxForwarding = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_forwarding";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxForwarding_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxQuota = function( uid  ) {

  var postUri = "/{uid}/_quota";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxQuota_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxRule = function( mailboxUid ,  id  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxRules = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_rules";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxRules_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {string} client
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxRulesByClient = function( mailboxUid ,  client  ) {

  var postUri = "/{mailboxUid}/_rulesByClient";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(client)) {
    url.getQueryData().add('client', client);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxRulesByClient_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getMailboxVacation = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_vacation";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMailboxVacation_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.getUnreadMessagesCount = function() {

  var postUri = "/_unread";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getUnreadMessagesCount_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.list = function() {

  var postUri = "/_list";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "list_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.listUids = function() {

  var postUri = "/_listUids";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "listUids_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} direction
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.moveMailboxRule = function( mailboxUid ,  id ,  direction  ) {

  var postUri = "/{mailboxUid}/_rules/{id}/{direction}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  postUri = postUri.replace("{direction}", goog.string.urlEncode(direction));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "moveMailboxRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + id
                                  + direction
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} position
 * @param {number} anchorId
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.moveMailboxRuleRelative = function( mailboxUid ,  id ,  position ,  anchorId  ) {

  var postUri = "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  postUri = postUri.replace("{position}", goog.string.urlEncode(position));
  postUri = postUri.replace("{anchorId}", goog.string.urlEncode(anchorId));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "moveMailboxRuleRelative_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + id
                                  + position
                                  + anchorId
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "multipleGet_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} filter
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setDomainFilter = function( filter  ) {

  var postUri = "/_filter";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setDomainFilter_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = filter;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Array.<Object>} accessControlEntries
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setMailboxAccessControlList = function( mailboxUid ,  accessControlEntries  ) {

  var postUri = "/{mailboxUid}/_acls";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setMailboxAccessControlList_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = accessControlEntries;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} delegationRule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setMailboxDelegationRule = function( mailboxUid ,  delegationRule  ) {

  var postUri = "/{mailboxUid}/_delegationRule";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setMailboxDelegationRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = delegationRule;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} filter
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setMailboxFilter = function( mailboxUid ,  filter  ) {

  var postUri = "/{mailboxUid}/_filter";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setMailboxFilter_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = filter;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} forwarding
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setMailboxForwarding = function( mailboxUid ,  forwarding  ) {

  var postUri = "/{mailboxUid}/_forwarding";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setMailboxForwarding_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = forwarding;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {Object} vacation
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.setMailboxVacation = function( mailboxUid ,  vacation  ) {

  var postUri = "/{mailboxUid}/_vacation";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setMailboxVacation_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = vacation;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} mailbox
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.update = function( uid ,  mailbox  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = mailbox;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.updateDomainRule = function( id ,  rule  ) {

  var postUri = "/_rules/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "updateDomainRule_" 
                                  + this.domainUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = rule;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {number} id
 * @param {Object} rule
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxesClient.prototype.updateMailboxRule = function( mailboxUid ,  id ,  rule  ) {

  var postUri = "/{mailboxUid}/_rules/{id}";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));
  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "updateMailboxRule_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = rule;
  return this.execute(cmd, body);
};

