/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.mailbox.api.IMailboxMgmt.
 */

goog.provide('net.bluemind.mailbox.api.MailboxMgmtClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.mailbox.api.IMailboxMgmt API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.mailbox.api.MailboxMgmtClient = function(rpc, base , domainUid ) {
  goog.base(this, rpc, base);
  this.base += '/mgmt/mailbox/{domainUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.mailbox.api.MailboxMgmtClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} numericIndex
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.addIndexToRing = function( numericIndex  ) {

  var postUri = "/{numericIndex}/_add_index";

  postUri = postUri.replace("{numericIndex}", goog.string.urlEncode(numericIndex));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "addIndexToRing_" 
                                  + this.domainUid_
                                  + numericIndex
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.consolidateDomain = function() {

  var postUri = "/_consolidate";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "consolidateDomain_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.consolidateMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_consolidate";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "consolidateMailbox_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} numericIndex
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.deleteIndexFromRing = function( numericIndex  ) {

  var postUri = "/{numericIndex}/_remove_index";

  postUri = postUri.replace("{numericIndex}", goog.string.urlEncode(numericIndex));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteIndexFromRing_" 
                                  + this.domainUid_
                                  + numericIndex
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.getLiteStats = function() {

  var postUri = "/liteStats";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getLiteStats_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.getShardsStats = function() {

  var postUri = "/shardsStats";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getShardsStats_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @param {string} index
 * @param {boolean} deleteSource
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.moveIndex = function( mailboxUid ,  index ,  deleteSource  ) {

  var postUri = "/{mailboxUid}/_move_index";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(index)) {
    url.getQueryData().add('index', index);
  }
  if (goog.isDefAndNotNull(deleteSource)) {
    url.getQueryData().add('deleteSource', deleteSource);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "moveIndex_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.resetMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_reset";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "resetMailbox_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} mailboxUid
 * @return {Object}
 */
net.bluemind.mailbox.api.MailboxMgmtClient.prototype.respawnMailbox = function( mailboxUid  ) {

  var postUri = "/{mailboxUid}/_respawn";

  postUri = postUri.replace("{mailboxUid}", goog.string.urlEncode(mailboxUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "respawnMailbox_" 
                                  + this.domainUid_
                                  + mailboxUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

