package net.bluemind.lib.elasticsearch.allocations.rebalance;

import java.util.Collections;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.lib.elasticsearch.allocations.AllocationShardStats;
import net.bluemind.lib.elasticsearch.allocations.AllocationSpecification;

public class RebalanceSpecificationBySize implements AllocationSpecification<Rebalance> {
	protected static final Logger logger = LoggerFactory.getLogger(RebalanceSpecificationBySize.class);

	public RebalanceSpecificationBySize() {

	}

	@Override
	public Rebalance apply(List<AllocationShardStats> existing) {
		long averageDocCount = Math.round(existing.stream().mapToLong(stat -> stat.docCount).average().orElse(0d));
		int startCount = 1;
		int totalBoxes = 0;
		for (AllocationShardStats ss : existing) {
			int idxId = Integer.parseInt(ss.indexName.substring("mailspool_ring_".length()));
			startCount = Math.max(startCount, idxId);
			totalBoxes += ss.mailboxes.size();

		}
		int avgBoxCount = totalBoxes / existing.size();

		logger.info("average box count: {}", avgBoxCount);

		existing.sort((s1, s2) -> Long.compare(s2.size, s1.size));
		int mid = existing.size() / 2;
		List<AllocationShardStats> sources = existing.subList(0, mid);
		List<AllocationShardStats> targets = existing.subList(mid, existing.size());
		Collections.reverse(targets);

		return new Rebalance(averageDocCount, sources, targets);
	}
}
