/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keydb.topology.bootstrap;

import java.util.function.Supplier;

import com.google.common.base.Suppliers;

import net.bluemind.keydb.common.IKeydbBootstrap;

public class KeydbDockerResolver implements IKeydbBootstrap {

	private static final Supplier<KeydbContainer> CONT = Suppliers.memoize(() -> {
		KeydbContainer keydb = new KeydbContainer();
		keydb.start();
		return keydb;
	});

	@Override
	public String keydbHost() {
		String dockerIp = CONT.get().inspectAddress();
		if (dockerIp != null) {
			return dockerIp;
		}

		return "localhost";
	}

	@Override
	public boolean isAvailable() {
		return ActivatorForTestContainers.dockerStrategyAvailable;
	}
}
