/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keydb.topology.bootstrap;

import java.util.concurrent.TimeUnit;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

import com.github.dockerjava.api.command.RestartContainerCmd;

import net.bluemind.network.utils.NetworkHelper;

public class KeydbContainer extends GenericContainer<KeydbContainer> {

	private static class LogConsumer extends BaseConsumer<LogConsumer> {

		@Override
		public void accept(OutputFrame t) {
			System.err.print(t.getUtf8String());
		}

	}

	public KeydbContainer() {
		super("docker.bluemind.net/bluemind/keydb:5.3.2480");
		withExposedPorts(6379);
		withReuse(false);
		withLogConsumer(new LogConsumer());
		waitingFor(new org.testcontainers.containers.wait.strategy.AbstractWaitStrategy() {

			@Override
			protected void waitUntilReady() {
				NetworkHelper nh = new NetworkHelper(inspectAddress());
				System.err.println("Waiting for " + inspectAddress() + ":" + 6379);
				nh.waitForListeningPort(6379, 30, TimeUnit.SECONDS);
			}

		});
	}

	public String inspectAddress() {
		return getContainerInfo().getNetworkSettings().getNetworks().get("bridge").getIpAddress();
	}

	@Override
	public void start() {
		super.start();
	}

	public void restart() {
		RestartContainerCmd restartCmd = getDockerClient().restartContainerCmd(getContainerId());
		restartCmd.exec();
	}
}
