/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keycloak.verticle;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import net.bluemind.keycloak.internal.KeycloakManager;

public class KeycloakConfigurationVerticle extends AbstractVerticle {
	private static final Logger logger = LoggerFactory.getLogger(KeycloakConfigurationVerticle.class);

	@Override
	public void start() {
		vertx.eventBus().consumer(KeycloakVerticleAddress.UPDATED, this::updateForDomain);
	}

	private void updateForDomain(Message<JsonObject> event) {
		String domainUid = Optional.ofNullable(event.body().getString("containerUid")).orElse("global.virt");

		try {
			KeycloakManager.forDomain(domainUid).update();
		} catch (Exception e) {
			logger.error("Unable to get OpenId configuration for domain {}", domainUid, e);
		}
	}
}
