/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.imap.endpoint.cmd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.bluemind.imap.endpoint.EndpointRuntimeException;
import net.bluemind.imap.endpoint.driver.ImapIdSet;
import net.bluemind.lib.jutf7.UTF7Converter;

public abstract class AbstractCopyCommand extends AnalyzedCommand {

	private final String folder;
	private final ImapIdSet idset;

	public AbstractCopyCommand(RawImapCommand raw, Pattern copyTemplate) {
		super(raw);
		String fetch = flattenAtoms(true).fullCmd;
		Matcher m = copyTemplate.matcher(fetch);

		if (m.find()) {
			idset = fromSerializedSet(m.group(1));
			folder = UTF7Converter.decode(m.group(2).replace("\"", ""));
		} else {
			throw new EndpointRuntimeException("Cannot analyze copy cmd " + fetch);
		}
	}

	public String folder() {
		return folder;
	}

	public ImapIdSet idset() {
		return idset;
	}

	protected abstract ImapIdSet fromSerializedSet(String set);

}
