/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.imap.endpoint.exec;

import java.time.Duration;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import net.bluemind.imap.endpoint.ImapContext;
import net.bluemind.imap.endpoint.cmd.BlockingCommand;
import net.bluemind.imap.endpoint.locks.ISequenceCheckpoint;
import net.bluemind.imap.endpoint.locks.ISequenceWriter;

public class BlockingProcessor extends SelectedStateCommandProcessor<BlockingCommand>
		implements ISequenceWriter, ISequenceCheckpoint {

	@Override
	public void checkedOperation(BlockingCommand command, ImapContext ctx, Handler<AsyncResult<Void>> completed) {
		// I will not call my completion handler in time
		Thread.ofVirtual().name("block:" + ctx).start(() -> {
			try {
				Thread.sleep(Duration.ofSeconds(command.durationSeconds()));
				ctx.write(command.raw().tag() + " OK Blocked\r\n").andThen(completed);
			} catch (InterruptedException e) {
				Thread.currentThread().interrupt();
				return;
			}
		});
	}

	@Override
	public Class<BlockingCommand> handledType() {
		return BlockingCommand.class;
	}

}
