<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ICalendarElementVAlarm.
 */
class ICalendarElementVAlarm  {

  /*
   * @type ICalendarElementVAlarmAction
   */
  public $action;

  /*
   * @type Integer
   */
  public $trigger;

  /*
   * @type String
   */
  public $description;

  /*
   * @type Integer
   */
  public $duration;

  /*
   * @type Integer
   */
  public $repeat;

  /*
   * @type String
   */
  public $summary;

  /*
   * Constructor
   */
  public function __construct() {
    $this->trigger = null;
    $this->description = "";
    $this->duration = null;
    $this->repeat = null;
    $this->summary = "";
  }

  public function toMap() {
    $data = array(    
        "action" => empty($this->action) ? null : $this->action,    
        "trigger" => empty($this->trigger) ? null : $this->trigger,    
        "description" => empty($this->description) ? null : $this->description,    
        "duration" => empty($this->duration) ? null : $this->duration,    
        "repeat" => empty($this->repeat) ? null : $this->repeat,    
        "summary" => empty($this->summary) ? null : $this->summary);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
