<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ICalendarElementAttendee.
 */
class ICalendarElementAttendee  {

  /*
   * @type ICalendarElementCUType
   */
  public $cutype;

  /*
   * @type String
   */
  public $member;

  /*
   * @type ICalendarElementRole
   */
  public $role;

  /*
   * @type ICalendarElementParticipationStatus
   */
  public $partStatus;

  /*
   * @type Boolean
   */
  public $rsvp;

  /*
   * @type String
   */
  public $delTo;

  /*
   * @type String
   */
  public $delFrom;

  /*
   * @type String
   */
  public $sentBy;

  /*
   * @type String
   */
  public $commonName;

  /*
   * @type String
   */
  public $dir;

  /*
   * @type String
   */
  public $lang;

  /*
   * @type String
   */
  public $mailto;

  /*
   * @type String
   */
  public $uri;

  /*
   * @type boolean
   */
  public $internal;

  /*
   * @type String
   */
  public $responseComment;

  /*
   * @type BmDateTime
   */
  public $counter;

  /*
   * Constructor
   */
  public function __construct() {
    $this->member = "";
    $this->rsvp = false;
    $this->delTo = "";
    $this->delFrom = "";
    $this->sentBy = "";
    $this->commonName = "";
    $this->dir = "";
    $this->lang = "";
    $this->mailto = "";
    $this->uri = "";
    $this->internal = false;
    $this->responseComment = "";
    $this->counter = null;
  }

  public function toMap() {
    $data = array(    
        "cutype" => empty($this->cutype) ? null : $this->cutype,    
        "member" => empty($this->member) ? null : $this->member,    
        "role" => empty($this->role) ? null : $this->role,    
        "partStatus" => empty($this->partStatus) ? null : $this->partStatus,    
        "rsvp" => empty($this->rsvp) ? null : $this->rsvp,    
        "delTo" => empty($this->delTo) ? null : $this->delTo,    
        "delFrom" => empty($this->delFrom) ? null : $this->delFrom,    
        "sentBy" => empty($this->sentBy) ? null : $this->sentBy,    
        "commonName" => empty($this->commonName) ? null : $this->commonName,    
        "dir" => empty($this->dir) ? null : $this->dir,    
        "lang" => empty($this->lang) ? null : $this->lang,    
        "mailto" => empty($this->mailto) ? null : $this->mailto,    
        "uri" => empty($this->uri) ? null : $this->uri,    
        "internal" => empty($this->internal) ? null : $this->internal,    
        "responseComment" => empty($this->responseComment) ? null : $this->responseComment,    
        "counter" => empty($this->counter) ? null : $this->counter);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
