/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.group.service.internal.cql;

import java.util.List;

import net.bluemind.directory.api.BaseDirEntry.Kind;
import net.bluemind.directory.repository.DirEntryNG;
import net.bluemind.group.api.Group;
import net.bluemind.group.service.GroupHelper;
import net.bluemind.mailbox.api.Mailbox;

public class DirGroupAdapter {

	public DirEntryNG fromGroup(Group g) {
		Mailbox asMbox = GroupHelper.groupToMailbox(g);
		DirEntryNG de = new DirEntryNG();
		de.kind = Kind.GROUP;
		de.hidden = g.hidden;
		de.archived = g.archived;
		de.emails = List.copyOf(g.emails);
		de.system = g.system;
		de.displayName = g.name;
		de.orgUnitUid = g.orgUnitUid;
		de.routing = asMbox.routing;
		de.mailboxName = asMbox.name;
		return de;
	}

	public Group fromEntry(DirEntryNG entry) {
		Group g = new Group();
		g.name = entry.displayName;
		g.system = entry.system;
		g.hidden = entry.hidden;
		g.archived = entry.archived;
		g.emails = entry.emails;
		return g;
	}

}
